/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.polynomial1;

import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.math.polynomial1.ILispPolynomial1;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.math.polynomial1.DoublePolynomial1;
import net.morilib.math.polynomial1.Polynomial1Solver;

public class SolvePolynomial1
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof ILispPolynomial1)) {
            throw mesg.getError("err.math.require.poly1", c1a);
        }
        ILispPolynomial1 p = (ILispPolynomial1)((Object)c1a);
        if (p.degree() >= 2) {
            double[] cef = new double[((ILispPolynomial1)((Object)c1a)).degree() + 1];
            int i = 0;
            while (i <= p.degree()) {
                cef[i] = SubrUtils.getDouble(p.coefficient(i), mesg);
                ++i;
            }
            DoublePolynomial1 dp = new DoublePolynomial1(cef);
            double[] rs = Polynomial1Solver.solveAll(dp);
            ConsListBuilder b = new ConsListBuilder();
            double[] dArray = rs;
            int n = rs.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                b.append(new LispDouble(d));
                ++n2;
            }
            return b.get();
        }
        if (p.degree() == 1) {
            return p.coefficient(1).div(p.coefficient(0)).uminus();
        }
        if (p.isZero()) {
            return LispBoolean.FALSE;
        }
        return Nil.NIL;
    }
}

