/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.probability;

import java.io.Serializable;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ISubr;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.AbstractLispQuantity;
import net.morilib.lisp.math.ILispQuantity;
import net.morilib.lisp.math.ILispQuantityFactory;
import net.morilib.lisp.math.algebra.ILispMultipliable;
import net.morilib.lisp.math.random.ILispRandomSource;
import net.morilib.lisp.math.random.LispMTRandomSource;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.random.MersenneTwisterRandom;
import net.morilib.math.random.RandomSource;
import net.morilib.util.Iterators;

public class LispProbability
extends AbstractLispQuantity
implements ILispMultipliable<LispProbability>,
ILispQuantity,
ISubr,
Serializable {
    private static final ILispQuantityFactory FACTORY = new ILispQuantityFactory(){

        @Override
        public ILispQuantity getInstance(LispReal r) {
            return new LispProbability(r);
        }
    };
    private static final LispInteger ONE_HUNDRED = LispInteger.valueOf(100);
    private LispReal p;

    public LispProbability(LispReal p) {
        if (p.compareTo(LispInteger.ZERO) < 0 || p.compareTo(LispInteger.ONE) > 0) {
            throw new IllegalArgumentException();
        }
        this.p = p;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        Datum f;
        RandomSource rnd;
        ConsIterator itr = new ConsIterator(body);
        Datum t = Iterators.nextIf(itr);
        if (t instanceof ILispRandomSource) {
            rnd = ((ILispRandomSource)((Object)t)).getRandomSource();
            t = LispBoolean.TRUE;
            f = LispBoolean.FALSE;
            SubrUtils.checkTerminated(itr, body, mesg);
        } else if (t != null) {
            f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum d = Iterators.nextIf(itr, LispMTRandomSource.getInstance());
            if (!(d instanceof ILispRandomSource)) {
                throw mesg.getError("err.srfi27.require.randomsource", d);
            }
            rnd = ((ILispRandomSource)((Object)d)).getRandomSource();
            SubrUtils.checkTerminated(itr, body, mesg);
        } else {
            rnd = MersenneTwisterRandom.getInstance();
            t = LispBoolean.TRUE;
            f = LispBoolean.FALSE;
        }
        return rnd.nextDouble3() < this.p.doubleValue() ? t : f;
    }

    @Override
    public LispProbability mul(LispProbability y) {
        return new LispProbability(this.p.multiply(y.p));
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append(this.p.multiply(ONE_HUNDRED)).append("%");
    }

    @Override
    public LispReal getReal() {
        return this.p;
    }

    @Override
    public ILispQuantityFactory factory() {
        return FACTORY;
    }
}

