/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.sequence;

import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.sequence.AbstractLispSequence;
import net.morilib.lisp.math.sequence.ILispRealSequence;
import net.morilib.lisp.math.sequence.ILispSequence;

public abstract class AbstractLispRealSequence
extends AbstractLispSequence
implements ILispRealSequence {
    @Override
    public ILispSequence add(ILispSequence y) {
        final AbstractLispRealSequence t = this;
        if (!(y instanceof ILispRealSequence)) {
            return super.add(y);
        }
        final ILispRealSequence s = (ILispRealSequence)y;
        return new AbstractLispRealSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite() && s.isFinite();
            }

            @Override
            public int size() {
                return this.isFinite() ? Math.max(t.size(), s.size()) : -1;
            }

            @Override
            public LispReal get(int i) {
                return t.get(i).add(s.get(i));
            }

            @Override
            public LispReal limit() {
                return t.limit().add(s.limit());
            }

            @Override
            public LispReal sum() {
                return t.sum().add(s.sum());
            }
        };
    }

    @Override
    public ILispSequence sub(ILispSequence y) {
        final AbstractLispRealSequence t = this;
        if (!(y instanceof ILispRealSequence)) {
            return super.add(y);
        }
        final ILispRealSequence s = (ILispRealSequence)y;
        return new AbstractLispRealSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite() && s.isFinite();
            }

            @Override
            public int size() {
                return this.isFinite() ? Math.max(t.size(), s.size()) : -1;
            }

            @Override
            public LispReal get(int i) {
                return t.get(i).subtract(s.get(i));
            }

            @Override
            public LispReal limit() {
                return t.limit().subtract(s.limit());
            }

            @Override
            public LispReal sum() {
                return t.sum().subtract(s.sum());
            }
        };
    }

    @Override
    public ILispSequence uminus() {
        final AbstractLispRealSequence t = this;
        return new AbstractLispRealSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite();
            }

            @Override
            public int size() {
                return t.size();
            }

            @Override
            public LispReal get(int i) {
                return t.get(i).negate();
            }

            @Override
            public LispReal limit() {
                return t.limit().negate();
            }

            @Override
            public LispReal sum() {
                return t.sum().negate();
            }
        };
    }

    @Override
    public ILispSequence mul(ILispSequence y) {
        final AbstractLispRealSequence t = this;
        if (!(y instanceof ILispRealSequence)) {
            return super.add(y);
        }
        final ILispRealSequence s = (ILispRealSequence)y;
        return new AbstractLispRealSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite() && s.isFinite();
            }

            @Override
            public int size() {
                return this.isFinite() ? Math.max(t.size(), s.size()) : -1;
            }

            @Override
            public LispReal get(int i) {
                return t.get(i).multiply(s.get(i));
            }

            @Override
            public LispReal limit() {
                return t.limit().multiply(s.limit());
            }
        };
    }

    @Override
    public ILispSequence div(ILispSequence y) {
        final AbstractLispRealSequence t = this;
        if (!(y instanceof ILispRealSequence)) {
            return super.add(y);
        }
        final ILispRealSequence s = (ILispRealSequence)y;
        return new AbstractLispRealSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite() && s.isFinite();
            }

            @Override
            public int size() {
                return this.isFinite() ? Math.max(t.size(), s.size()) : -1;
            }

            @Override
            public LispReal get(int i) {
                return t.get(i).divide(s.get(i));
            }

            @Override
            public LispReal limit() {
                return t.limit().divide(s.limit());
            }
        };
    }

    @Override
    public ILispSequence inv() {
        final AbstractLispRealSequence t = this;
        return new AbstractLispRealSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite();
            }

            @Override
            public int size() {
                return t.size();
            }

            @Override
            public LispReal get(int i) {
                return (LispReal)t.get(i).invert();
            }

            @Override
            public LispReal limit() {
                return (LispReal)t.limit().invert();
            }
        };
    }

    @Override
    public ILispRealSequence difference() {
        final AbstractLispRealSequence t = this;
        return new AbstractLispRealSequence(){

            @Override
            public LispReal get(int i) {
                return t.get(i + 1).subtract(t.get(i));
            }

            @Override
            public LispReal limit() {
                return t.limit();
            }

            @Override
            public LispReal sum() {
                return null;
            }

            @Override
            public boolean isFinite() {
                return t.isFinite();
            }

            @Override
            public int size() {
                return t.isFinite() ? t.size() - 1 : -1;
            }
        };
    }

    @Override
    public LispReal sum(int start, int end) {
        LispReal r = LispInteger.ZERO;
        if (start < 1) {
            throw new IllegalArgumentException();
        }
        if (end < 1) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int i = start;
        while (i <= end && i <= this.size()) {
            r = r.add((LispReal)this.get(i));
            ++i;
        }
        return r;
    }

    @Override
    public LispReal sum() {
        LispReal r = LispInteger.ZERO;
        if (!this.isFinite()) {
            return null;
        }
        int i = 1;
        while (i <= this.size()) {
            r = r.add((LispReal)this.get(i));
            ++i;
        }
        return r;
    }
}

