/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.sequence;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.iterator.ILispIterable;
import net.morilib.lisp.iterator.ILispIterator;
import net.morilib.lisp.math.sequence.ILispSequence;

public abstract class AbstractLispSequence
extends Datum2
implements ILispSequence,
ILispIterable {
    @Override
    public ILispSequence add(final ILispSequence y) {
        final AbstractLispSequence t = this;
        return new AbstractLispSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite() && y.isFinite();
            }

            @Override
            public int size() {
                return this.isFinite() ? Math.max(t.size(), y.size()) : -1;
            }

            @Override
            public LispNumber get(int i) {
                return t.get(i).add(y.get(i));
            }

            @Override
            public LispNumber limit() {
                return t.limit().add(y.limit());
            }
        };
    }

    @Override
    public ILispSequence sub(final ILispSequence y) {
        final AbstractLispSequence t = this;
        return new AbstractLispSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite() && y.isFinite();
            }

            @Override
            public int size() {
                return this.isFinite() ? Math.max(t.size(), y.size()) : -1;
            }

            @Override
            public LispNumber get(int i) {
                return t.get(i).sub(y.get(i));
            }

            @Override
            public LispNumber limit() {
                return t.limit().sub(y.limit());
            }
        };
    }

    @Override
    public ILispSequence uminus() {
        final AbstractLispSequence t = this;
        return new AbstractLispSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite();
            }

            @Override
            public int size() {
                return t.size();
            }

            @Override
            public LispNumber get(int i) {
                return t.get(i).uminus();
            }

            @Override
            public LispNumber limit() {
                return t.limit().uminus();
            }
        };
    }

    @Override
    public ILispSequence mul(final ILispSequence y) {
        final AbstractLispSequence t = this;
        return new AbstractLispSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite() && y.isFinite();
            }

            @Override
            public int size() {
                return this.isFinite() ? Math.max(t.size(), y.size()) : -1;
            }

            @Override
            public LispNumber get(int i) {
                return t.get(i).mul(y.get(i));
            }

            @Override
            public LispNumber limit() {
                return t.limit().mul(y.limit());
            }
        };
    }

    @Override
    public ILispSequence div(final ILispSequence y) {
        final AbstractLispSequence t = this;
        return new AbstractLispSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite() && y.isFinite();
            }

            @Override
            public int size() {
                return this.isFinite() ? Math.max(t.size(), y.size()) : -1;
            }

            @Override
            public LispNumber get(int i) {
                return t.get(i).div(y.get(i));
            }

            @Override
            public LispNumber limit() {
                return t.limit().div(y.limit());
            }
        };
    }

    @Override
    public ILispSequence inv() {
        final AbstractLispSequence t = this;
        return new AbstractLispSequence(){

            @Override
            public boolean isFinite() {
                return t.isFinite();
            }

            @Override
            public int size() {
                return t.size();
            }

            @Override
            public LispNumber get(int i) {
                return t.get(i).inv();
            }

            @Override
            public LispNumber limit() {
                return t.limit().inv();
            }
        };
    }

    @Override
    public ILispIterator lispIterator() {
        final int[] c = new int[]{1};
        return new ILispIterator(){

            @Override
            public boolean isTerminated() {
                return c[0] >= AbstractLispSequence.this.size() || c[0] <= 0;
            }

            @Override
            public ILispIterator next() {
                c[0] = c[0] + 1;
                return this;
            }

            @Override
            public Datum getCurrentDatum() {
                return AbstractLispSequence.this.get(c[0]);
            }
        };
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("{");
        int i = 0;
        while (i < 10 && i < this.size()) {
            buf.append(" ").append(this.get(i));
            ++i;
        }
        if (i < this.size()) {
            buf.append("...");
        }
        buf.append("}");
    }
}

