/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.sequence;

import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.sequence.AbstractLispRealSequence;
import net.morilib.lisp.math.sequence.ILispRealSequence;

public class LispRealConstantSequence
extends AbstractLispRealSequence {
    public static final int INFINITE = -1;
    private LispReal value;
    private int size;

    public LispRealConstantSequence(LispReal value, int size) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        this.size = size;
    }

    @Override
    public LispReal get(int i) {
        if (i < 1) {
            throw new IndexOutOfBoundsException();
        }
        return i <= this.size ? this.value : LispInteger.ZERO;
    }

    @Override
    public LispReal limit() {
        return this.size < 0 ? this.value : LispInteger.ZERO;
    }

    @Override
    public boolean isFinite() {
        return this.size > 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ILispRealSequence difference() {
        if (this.size >= 2) {
            return new LispRealConstantSequence(LispInteger.ZERO, this.size - 1);
        }
        return this;
    }

    @Override
    public LispReal sum(int start, int end) {
        if (start < 1) {
            throw new IllegalArgumentException();
        }
        if (end < 1) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            throw new IllegalArgumentException();
        }
        return (LispReal)this.value.multiply(end - start + 1);
    }

    @Override
    public LispReal sum() {
        if (this.value.signum() == 0) {
            return this.value;
        }
        if (this.size >= 1) {
            return (LispReal)this.value.multiply(this.size);
        }
        if (this.value.signum() > 0) {
            return LispDouble.POSITIVE_INFINITY;
        }
        return LispDouble.NEGATIVE_INFINITY;
    }
}

