/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.Subr;
import net.morilib.lisp.math.ILispQuantity;
import net.morilib.lisp.math.ILispQuantityFactory;

public class HarmonicMean
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        ILispQuantityFactory f = null;
        LispReal r = LispInteger.ZERO;
        int n = 0;
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!(d instanceof ILispQuantity)) {
                throw mesg.getError("err.stat.require.quantity", d);
            }
            ILispQuantity q = (ILispQuantity)((Object)d);
            if (q.getReal().isZero()) {
                throw mesg.getError("err.divbyzero", d);
            }
            if (f == null) {
                f = q.factory();
                r = (LispReal)q.getReal().invert();
            } else {
                if (!f.equals(q.factory())) {
                    throw mesg.getError("err.stat.require.samequantity", d);
                }
                r = r.add((LispReal)q.getReal().invert());
            }
            ++n;
        }
        if (f == null) {
            return LispInteger.ZERO;
        }
        return (Datum)((Object)f.getInstance(LispInteger.valueOf(n).divide(r)));
    }
}

