/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.data;

import java.util.Arrays;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.stat.dist.ILispDistribution;
import net.morilib.math.stat.StatisticsUtils;
import net.morilib.math.stat.dist.Distribution;
import net.morilib.math.stat.dist.Histogram;

public class LispStatisticsData
extends Datum2
implements ILispDistribution {
    private double[] data;
    private Histogram histogram;
    private final Distribution distribution = new Distribution(){

        @Override
        public double f(double x) {
            return LispStatisticsData.this.histogram.f(x);
        }

        @Override
        public double cdf(double x) {
            return LispStatisticsData.this.histogram.cdf(x);
        }

        @Override
        public double cdf(double x1, double x2) {
            return LispStatisticsData.this.histogram.cdf(x1, x2);
        }

        @Override
        public double expectedValue() {
            return StatisticsUtils.mean(LispStatisticsData.this.data);
        }

        @Override
        public double variance() {
            return StatisticsUtils.variance(LispStatisticsData.this.data);
        }

        @Override
        public double mode() {
            return LispStatisticsData.this.histogram.mode();
        }

        @Override
        public double median() {
            return LispStatisticsData.this.data[LispStatisticsData.this.data.length / 2];
        }

        @Override
        public double skewness() {
            return StatisticsUtils.skewness(LispStatisticsData.this.data);
        }

        @Override
        public double kurtosis() {
            return StatisticsUtils.kurtosis(LispStatisticsData.this.data);
        }
    };

    LispStatisticsData(double ... vals) {
        this.data = vals;
        Arrays.sort(this.data);
        this.histogram = new Histogram(this.data);
    }

    @Override
    public LispReal integrate(LispReal a, LispReal b) {
        return new LispDouble(this.distribution.cdf(a.doubleValue(), b.doubleValue()));
    }

    @Override
    public Distribution getDistribution() {
        return this.distribution;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<statictics-data>");
    }
}

