/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.dist;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.math.stat.dist.LispBinomialDistribution;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;

public class MakeBinomialDistribution
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        BigInteger n = SubrUtils.getBigInteger(c1a, mesg);
        if (n.signum() <= 0) {
            throw mesg.getError("err.require.real.positive", c1a);
        }
        double p = SubrUtils.getDouble(c2a, mesg);
        if (p < 0.0 || p > 1.0) {
            throw mesg.getError("err.probability.range.invalid", c2a);
        }
        return new LispBinomialDistribution(n, p);
    }
}

