/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.dist;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.math.stat.dist.LispGammaDistribution;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.stat.dist.continuous.GammaDistribution;

public class MakeErlangDistribution
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        int k = SubrUtils.getSmallInt(c1a, mesg);
        double lambda = SubrUtils.getDouble(c2a, mesg);
        if (k <= 0) {
            throw mesg.getError("err.require.int.positive", c1a);
        }
        if (lambda <= 0.0) {
            throw mesg.getError("err.require.real.positive", c2a);
        }
        return new LispGammaDistribution(GammaDistribution.erlang(k, lambda));
    }
}

