/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.xy;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.math.stat.xy.ILispXYData;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;
import net.morilib.util.primitive.DoubleArrayVector;

public abstract class SubrXyProperties
extends Subr {
    protected abstract Datum lispXy(ILispXYData var1);

    protected abstract Datum statdouble(double[] var1, double[] var2);

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum dx = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum dy = Iterators.nextIf(itr);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (dx instanceof ILispXYData && dy == null) {
            return this.lispXy((ILispXYData)((Object)dx));
        }
        if (dy != null) {
            DoubleArrayVector x = new DoubleArrayVector();
            DoubleArrayVector y = new DoubleArrayVector();
            ConsIterator xtr = new ConsIterator(dx);
            ConsIterator ytr = new ConsIterator(dy);
            while (xtr.hasNext() && ytr.hasNext()) {
                x.addDouble(SubrUtils.getDouble(xtr.next(), mesg));
                y.addDouble(SubrUtils.getDouble(ytr.next(), mesg));
            }
            if (xtr.hasNext() || ytr.hasNext()) {
                throw mesg.getError("err.stat.xydata.samesize");
            }
            if (x.size() == 0) {
                throw mesg.getError("err.require.list.notnull");
            }
            return this.statdouble(x.toDoubleArray(), y.toDoubleArray());
        }
        throw mesg.getError("err.argument", body);
    }
}

