/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.http;

import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.Iterator;
import java.util.Map;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.net.http.LispHttpConnection;
import net.morilib.lisp.subr.SubrUtils;

public class HttpPropertiesSetS
extends Subr {
    private static final Symbol ALLOW_USER_INTERACTION = Symbol.getSymbol("allow-user-interatction");
    private static final Symbol IF_MODIFIED_SINCE = Symbol.getSymbol("if-modified-since");
    private static final Symbol USE_CHCHES = Symbol.getSymbol("use-caches");
    private static final Symbol CHUNKED_STREAMING_MODE = Symbol.getSymbol("chunked-streaming-mode");
    private static final Symbol FIXED_LENGTH_STREAMING_MODE = Symbol.getSymbol("fixed-length-streaming-mode");
    private static final Symbol REQUEST_METHOD = Symbol.getSymbol("request-method");

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        String mth = null;
        SubrUtils.checkTerminated(itr, body, mesg);
        Map<Datum, Datum> prm = LispUtils.assocToMap(c2a);
        if (prm == null) {
            throw mesg.getError("err.require.assoc", c2a);
        }
        if (c1a instanceof LispHttpConnection) {
            HttpURLConnection con = ((LispHttpConnection)c1a).connection;
            try {
                for (Map.Entry<Datum, Datum> e : prm.entrySet()) {
                    if (e.getKey().equals(ALLOW_USER_INTERACTION)) {
                        con.setAllowUserInteraction(e.getValue().isTrue());
                        continue;
                    }
                    if (e.getKey().equals(IF_MODIFIED_SINCE)) {
                        con.setIfModifiedSince(SubrUtils.getLongExact(e.getValue(), mesg));
                        continue;
                    }
                    if (e.getKey().equals(USE_CHCHES)) {
                        con.setUseCaches(e.getValue().isTrue());
                        continue;
                    }
                    if (e.getKey().equals(CHUNKED_STREAMING_MODE)) {
                        con.setChunkedStreamingMode(SubrUtils.getSmallInt(e.getValue(), mesg));
                        continue;
                    }
                    if (e.getKey().equals(FIXED_LENGTH_STREAMING_MODE)) {
                        int x0 = SubrUtils.getSmallInt(e.getValue(), mesg);
                        if (x0 < 0) {
                            throw mesg.getError("err.require.int.nonnegative", e.getValue());
                        }
                        con.setFixedLengthStreamingMode(x0);
                        continue;
                    }
                    if (e.getKey().equals(REQUEST_METHOD)) {
                        if (e.getValue() instanceof Symbol) {
                            mth = ((Symbol)e.getValue()).getName().toUpperCase();
                        } else if (e.getValue() instanceof LispString) {
                            mth = e.getValue().getString().toUpperCase();
                        } else {
                            throw mesg.getError("err.net.httpmethod.invalid", e.getValue());
                        }
                        try {
                            con.setRequestMethod(mth);
                            continue;
                        }
                        catch (ProtocolException e1) {
                            throw mesg.getError("err.net.httpmethod.invalid", e.getValue());
                        }
                    }
                    if (e.getKey() instanceof LispString) {
                        if (e.getValue() instanceof LispString) {
                            con.setRequestProperty(e.getKey().getString(), e.getValue().getString());
                            continue;
                        }
                        throw mesg.getError("err.require.string", e.getValue());
                    }
                    throw mesg.getError("err.net.httprequestparameter.invalid", e.getKey());
                }
                if (mth == null) {
                    throw mesg.getError("err.net.protocol.invalid");
                }
                if (mth.equals("POST")) {
                    con.setDoOutput(true);
                }
                return Undef.UNDEF;
            }
            catch (IllegalStateException e) {
                throw mesg.getError("err.net.http.alreadyconnected");
            }
        }
        throw mesg.getError("err.net.require.httpconnection", c1a);
    }
}

