/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.mail;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.net.LispInetAddress;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.net.mail.SMTP;

public class SendMail
extends Subr {
    static String defaultEncoding;

    static {
        String lang = Locale.getDefault().getLanguage();
        defaultEncoding = lang.equals(Locale.JAPANESE.getLanguage()) ? "ISO-2022-JP" : (lang.equals(Locale.ENGLISH.getLanguage()) ? null : null);
    }

    private List<String> tolist(Datum b, LispMessage mesg) {
        ConsIterator i2 = new ConsIterator(b);
        ArrayList<String> s = new ArrayList<String>();
        while (i2.hasNext()) {
            s.add(SubrUtils.getString(i2.next(), mesg));
        }
        if (!i2.rest().isNil()) {
            throw mesg.getError("err.list", b);
        }
        return s;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        Datum d3;
        int port;
        ConsIterator itr = new ConsIterator(body);
        Datum host = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (d2 instanceof LispSmallInt) {
            port = SubrUtils.getSmallInt(d2, mesg);
            d3 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        } else {
            port = 25;
            d3 = d2;
        }
        String from = SubrUtils.getString(d3, mesg);
        List<String> to = this.tolist(SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body), mesg);
        List<String> cc = this.tolist(SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body), mesg);
        List<String> bcc = this.tolist(SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body), mesg);
        String subj = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
        String text = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
        SubrUtils.checkTerminated(itr, body, mesg);
        try {
            if (host instanceof LispString) {
                SMTP.send(host.getString(), port, subj, from, to, cc, bcc, text, defaultEncoding);
            } else if (host instanceof LispInetAddress) {
                SMTP.send(((LispInetAddress)host).getAddress(), port, subj, from, to, cc, bcc, text, defaultEncoding);
            }
        }
        catch (ProtocolException e) {
            throw mesg.getError("err.net.smtp", e.getMessage());
        }
        catch (IOException e) {
            throw mesg.getError("err.io");
        }
        return Undef.UNDEF;
    }
}

