/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.misc;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.SubrNetUtils;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.net.misc.TFTP;
import net.morilib.util.IOs;

public class TftpGet
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        LispInteger lispInteger;
        ConsIterator itr = new ConsIterator(body);
        BufferedOutputStream ous = null;
        int port = 69;
        try {
            String mode;
            InetAddress addr = SubrNetUtils.nextAddress(itr, body, mesg);
            Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (d2 instanceof LispSmallInt) {
                port = SubrUtils.getSmallInt(d2, mesg);
                mode = SubrUtils.nextSymbolName((Iterator<Datum>)itr, mesg, body);
            } else {
                mode = SubrUtils.getSymbolName(d2, mesg);
            }
            String fn = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            String ofn = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            ous = new BufferedOutputStream(new FileOutputStream(ofn));
            long l = TFTP.get(addr, port, fn, mode, (OutputStream)ous);
            ous.flush();
            lispInteger = LispInteger.valueOf(l);
        }
        catch (IOException e) {
            try {
                throw mesg.getError("err.io", e.getMessage());
            }
            catch (Throwable throwable) {
                IOs.close(ous);
                throw throwable;
            }
        }
        IOs.close(ous);
        return lispInteger;
    }
}

