/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nio;

import java.nio.ReadOnlyBufferException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispEndianness;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.nio.LispBlob;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;

public class BlobS16SetS
extends QuaternaryArgs {
    private static short getNumber(Datum d, LispMessage mesg) {
        if (!(d instanceof LispInteger)) {
            throw mesg.getError("err.require.real", d);
        }
        if (((LispInteger)d).inShortRange()) {
            return (short)d.getInt();
        }
        throw mesg.getError("err.uvector.outofrange.s8", d);
    }

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof LispEndianness.Endian)) {
            throw mesg.getError("err.srfi74.require.endianness", c1a);
        }
        if (c2a instanceof LispBlob) {
            int k = SubrUtils.getSmallInt(c3a, mesg);
            try {
                ((LispBlob)c2a).order((LispEndianness.Endian)c2a);
                ((LispBlob)c2a).putShort(k, BlobS16SetS.getNumber(c4a, mesg));
                return Undef.UNDEF;
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi74.blob.outofrange", "" + k);
            }
            catch (ReadOnlyBufferException e) {
                throw mesg.getError("err.srfi74.buffer.readonly");
            }
        }
        throw mesg.getError("err.srfi74.require.blob", c1a);
    }
}

