/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nio;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispEndianness;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.nio.LispBlob;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;

public class SintListToBlob
extends TernaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        int s = SubrUtils.getSmallInt(c1a, mesg);
        BigInteger max = BigInteger.ONE.shiftLeft(s * 8 - 1);
        BigInteger min = BigInteger.ONE.shiftLeft(s * 8 - 1).negate();
        if (!(c2a instanceof LispEndianness.Endian)) {
            throw mesg.getError("err.srfi74.require.endianness", c2a);
        }
        ConsIterator itr = new ConsIterator(c3a);
        int l = LispUtils.consLength(c3a);
        ByteBuffer b = ByteBuffer.allocate(l * s);
        byte[] a = new byte[s];
        b.order(((LispEndianness.Endian)c2a).getByteOrder());
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (d instanceof LispInteger) {
                BigInteger x = d.getBigInteger();
                byte[] z = x.toByteArray();
                if (x.compareTo(max) >= 0 || x.compareTo(min) < 0) {
                    throw mesg.getError("err.srfi74.value.outofrange", d);
                }
                Arrays.fill(a, (byte)0);
                System.arraycopy(z, 0, a, s - z.length, z.length);
                b.put(a);
                continue;
            }
            throw mesg.getError("err.require.int", d);
        }
        SubrUtils.checkTerminated(itr, c3a, mesg);
        return new LispBlob(b);
    }
}

