/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.painter.SchlushFont;
import net.morilib.lisp.painter.SchlushFrame;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;
import net.morilib.lisp.painter.geom.MutablePoint2D;

public abstract class SchlushBufferedFrame
extends Datum2
implements SchlushFrame {
    protected CoordinateMap coordinate;
    private List<SchlushFrame.ImageInfo> images = new ArrayList<SchlushFrame.ImageInfo>();
    private List<Drawer> drawers = new ArrayList<Drawer>();
    private List<Drawer> bgdrawers = new ArrayList<Drawer>();
    private Map<Ipt, Rectangle2D> queue = new HashMap<Ipt, Rectangle2D>();

    public SchlushBufferedFrame(CoordinateMap coordinate) {
        this.coordinate = coordinate;
    }

    public SchlushBufferedFrame() {
        this(null);
    }

    protected abstract void loadImage(Image var1) throws InterruptedException;

    protected void paintImage(Graphics g, SchlushFrame.ImageInfo info, Component c) {
        if (this.coordinate != null) {
            MutablePoint2D p0 = this.coordinate.transform(this.getWidth(), this.getHeight(), info.x, info.y);
            MutablePoint2D ps = this.coordinate.transformSize(this.getWidth(), this.getHeight(), info.sx, info.sy);
            g.drawImage(info.img, p0.getXInt(), p0.getYInt() - ps.getYInt(), c);
        } else {
            g.drawImage(info.img, (int)info.x, (int)info.y, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintDrawers(Graphics g2, Component c) {
        Graphics g = g2;
        Object object = this.bgdrawers;
        synchronized (object) {
            for (Drawer drawer : this.bgdrawers) {
                drawer.draw(g, this.getWidth(), this.getHeight(), this.coordinate);
            }
        }
        object = this.images;
        synchronized (object) {
            for (SchlushFrame.ImageInfo info : this.images) {
                this.paintImage(g, info, c);
            }
        }
        object = this.drawers;
        synchronized (object) {
            for (Drawer drawer : this.drawers) {
                drawer.draw(g, this.getWidth(), this.getHeight(), this.coordinate);
            }
        }
        object = this.queue;
        synchronized (object) {
            Graphics2D g2d = (Graphics2D)g;
            for (Map.Entry<Ipt, Rectangle2D> e : this.queue.entrySet()) {
                TextLayout tl = new TextLayout(e.getKey().str, e.getKey().fnt, g2d.getFontRenderContext());
                e.setValue(tl.getBounds());
            }
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addImage(SchlushFrame.ImageInfo img) throws InterruptedException {
        Image img2 = null;
        if (this.coordinate != null) {
            MutablePoint2D ps = this.coordinate.transformSize(this.getWidth(), this.getHeight(), img.sx, img.sy);
            if (ps.getXInt() > 0 && ps.getYInt() > 0) {
                img2 = img.img.getScaledInstance(ps.getXInt(), ps.getYInt(), 4);
            }
        } else if ((int)img.sx > 0 && (int)img.sy > 0) {
            img2 = img.img.getScaledInstance((int)img.sx, (int)img.sy, 4);
        }
        if (img2 != null) {
            this.loadImage(img.img);
            List<SchlushFrame.ImageInfo> list = this.images;
            synchronized (list) {
                this.images.add(new SchlushFrame.ImageInfo(img2, img.x, img.y, img.sx, img.sy));
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDrawer(Drawer drawer) {
        List<Drawer> list = this.drawers;
        synchronized (list) {
            this.drawers.add(drawer);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBackgroundDrawer(Drawer drawer) {
        List<Drawer> list = this.bgdrawers;
        synchronized (list) {
            this.bgdrawers.add(drawer);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScreen() {
        List<Object> list = this.images;
        synchronized (list) {
            this.images.clear();
        }
        list = this.drawers;
        synchronized (list) {
            this.drawers.clear();
        }
        this.repaint();
    }

    @Override
    public CoordinateMap getCoordinate() {
        return this.coordinate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle2D calculateFontBounds(String str, SchlushFont font) {
        Ipt ipt = new Ipt();
        ipt.str = str;
        ipt.fnt = font.font;
        Map<Ipt, Rectangle2D> map = this.queue;
        synchronized (map) {
            this.queue.put(ipt, null);
            this.repaint();
            try {
                if (this.queue.get(ipt) == null) {
                    this.queue.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.queue.remove(ipt);
    }

    @Override
    public double transformX(double x) {
        return this.coordinate.transform(this.getWidth(), this.getHeight(), x, 0.0).getX();
    }

    @Override
    public double transformY(double y) {
        return this.coordinate.transform(this.getWidth(), this.getHeight(), 0.0, y).getY();
    }

    @Override
    public double invertX(int x) {
        return this.coordinate.invert(this.getWidth(), this.getHeight(), x, 0.0).getX();
    }

    @Override
    public double invertY(int y) {
        return this.coordinate.invert(this.getWidth(), this.getHeight(), 0.0, y).getY();
    }

    private class Ipt {
        private String str;
        private Font fnt;

        private Ipt() {
        }
    }
}

