/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Image;
import java.awt.geom.Rectangle2D;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.painter.SchlushFont;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;
import net.morilib.lisp.subr.BinaryArgs;

public interface SchlushFrame {
    public void addImage(ImageInfo var1) throws InterruptedException;

    public void addDrawer(Drawer var1);

    public void addBackgroundDrawer(Drawer var1);

    public int getImageWidth(Image var1);

    public int getImageHeight(Image var1);

    public void clearScreen();

    public CoordinateMap getCoordinate();

    public int getHeight();

    public int getWidth();

    public double transformX(double var1);

    public double transformY(double var1);

    public double invertX(int var1);

    public double invertY(int var1);

    public Rectangle2D calculateFontBounds(String var1, SchlushFont var2);

    public void repaint();

    public static class GetFrameCoordinateX
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof SchlushFrame)) {
                throw mesg.getError("err.require.frame", c1a);
            }
            if (!(c2a instanceof LispReal)) {
                throw mesg.getError("err.require.real", c2a);
            }
            return new LispDouble(((SchlushFrame)((Object)c1a)).invertX(c2a.getInt()));
        }
    }

    public static class GetFrameCoordinateY
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof SchlushFrame)) {
                throw mesg.getError("err.require.frame", c1a);
            }
            if (!(c2a instanceof LispSmallInt)) {
                throw mesg.getError("err.require.smallint", c2a);
            }
            return new LispDouble(((SchlushFrame)((Object)c1a)).invertY(c2a.getInt()));
        }
    }

    public static class ImageInfo {
        Image img;
        double x;
        double y;
        double sx;
        double sy;

        public ImageInfo(Image img, double x, double y, double sx, double sy) {
            this.img = img;
            this.x = x;
            this.y = y;
            this.sx = sx;
            this.sy = sy;
        }
    }
}

