/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.phys.unit;

import java.io.Serializable;
import net.morilib.lang.Hashes;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.AbstractLispQuantity;
import net.morilib.lisp.math.ILispQuantityFactory;
import net.morilib.lisp.math.algebra.ILispField;
import net.morilib.lisp.math.algebra.ILispScalarMultipliable;
import net.morilib.lisp.phys.unit.LispUnit;
import net.morilib.lisp.phys.unit.LispUnitSystem;
import net.morilib.phys.unit.Unit;
import net.morilib.phys.unit.UnitSystem;

public class LispQuantity
extends AbstractLispQuantity
implements ILispField<LispQuantity>,
ILispScalarMultipliable<LispQuantity>,
Serializable {
    private double value;
    private Unit unit;

    public LispQuantity(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public double getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public LispQuantity add(LispQuantity y) {
        if (!this.unit.equals(y.unit)) {
            throw new ClassCastException();
        }
        return new LispQuantity(this.value + y.value, this.unit);
    }

    @Override
    public LispQuantity sub(LispQuantity y) {
        if (!this.unit.equals(y.unit)) {
            throw new ClassCastException();
        }
        return new LispQuantity(this.value - y.value, this.unit);
    }

    @Override
    public LispQuantity uminus() {
        return new LispQuantity(-this.value, this.unit);
    }

    @Override
    public LispQuantity mul(LispQuantity y) {
        return new LispQuantity(this.value * y.value, this.unit.multiply(y.unit));
    }

    @Override
    public LispQuantity div(LispQuantity y) {
        return new LispQuantity(this.value / y.value, this.unit.divide(y.unit));
    }

    @Override
    public LispQuantity inv() {
        return new LispQuantity(1.0 / this.value, this.unit.invert());
    }

    @Override
    public LispQuantity mul(LispNumber x) {
        if (!x.isReal()) {
            throw new ClassCastException();
        }
        return new LispQuantity(this.value * x.getRealDouble(), this.unit);
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (Hashes.hashCode(this.value) + r);
        r = 37 * (this.unit.hashCode() + r);
        return r;
    }

    public boolean equals(Object o) {
        return o instanceof LispQuantity && this.value == ((LispQuantity)o).value && this.unit.equals(((LispQuantity)o).unit);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        UnitSystem sys = LispUnitSystem.defaultSystem.sys;
        double ms = Math.pow(1000.0, this.unit.getIndex("mass"));
        buf.append(this.value / ms).append(sys.getDescription(this.unit));
    }

    @Override
    public LispReal getReal() {
        return new LispDouble(this.value);
    }

    @Override
    public ILispQuantityFactory factory() {
        return new LispUnit(this.unit);
    }
}

