/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.process;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.process.ProcessSyntaxException;
import net.morilib.util.IOs;
import net.morilib.util.primitive.IntegerArrayVector;
import net.morilib.util.primitive.IntegerCollection;

public final class ProcessSubrUtils {
    private static final Writer stdout = new OutputStreamWriter(System.out);
    private static final Writer stderr = new OutputStreamWriter(System.err);

    private ProcessSubrUtils() {
    }

    public static int execProcessWithoutThread(List<String[]> r, Map<String, String> env, String dir, IntegerCollection e2o, Reader ins, Writer ous, Writer err) throws IOException {
        ProcessBuilder[] pb = new ProcessBuilder[r.size()];
        Process[] pip = new Process[r.size()];
        Writer[] ppo = new Writer[r.size() + 1];
        Reader[] ppi = new Reader[r.size()];
        Reader[] ppe = new Reader[r.size()];
        char[] b = new char[1024];
        int l = 0;
        int res = 72;
        int i = 0;
        while (i < r.size()) {
            pb[i] = new ProcessBuilder(r.get(i));
            pb[i] = pb[i].redirectErrorStream(e2o.containsInt(i));
            pb[i].environment().putAll(env);
            pb[i].directory(new File(dir));
            pip[i] = pb[i].start();
            ppo[i] = new BufferedWriter(new OutputStreamWriter(pip[i].getOutputStream()));
            ppi[i] = new BufferedReader(new InputStreamReader(pip[i].getInputStream()));
            ppe[i] = new BufferedReader(new InputStreamReader(pip[i].getErrorStream()));
            ++i;
        }
        Writer writer = ppo[r.size()] = ous != null ? ous : stdout;
        if (ins != null) {
            while ((l = ins.read(b)) >= 0) {
                ppo[0].write(b, 0, l);
                ppo[0].flush();
            }
            IOs.close(ppo[0]);
        }
        i = 0;
        while (i < r.size()) {
            while (true) {
                if ((l = ppi[i].read(b)) >= 0) {
                    ppo[i + 1].write(b, 0, l);
                    ppo[i + 1].flush();
                } else if (l < 0) {
                    if (i < r.size() - 1) {
                        IOs.close(ppo[i + 1]);
                    }
                    ppo[i + 1] = null;
                }
                l = ppe[i].read(b);
                if (l >= 0) {
                    (err != null ? err : stderr).write(b, 0, l);
                    (err != null ? err : stderr).flush();
                }
                try {
                    res = pip[i].exitValue();
                    if (ppo[i + 1] != null) continue;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    continue;
                }
                break;
            }
            ++i;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execProcess(final List<String[]> r, Map<String, String> env, String dir, IntegerCollection e2o, final Reader ins, Writer ous, final Writer err) throws IOException {
        ProcessBuilder[] pb = new ProcessBuilder[r.size()];
        final Process[] pip = new Process[r.size()];
        final Writer[] ppo = new Writer[r.size() + 1];
        final Reader[] ppi = new Reader[r.size()];
        final Reader[] ppe = new Reader[r.size()];
        final IOException[] lock = new IOException[1];
        int i = 0;
        while (i < r.size()) {
            pb[i] = new ProcessBuilder(r.get(i));
            pb[i] = pb[i].redirectErrorStream(e2o.containsInt(i));
            pb[i].environment().putAll(env);
            pb[i].directory(new File(dir));
            pip[i] = pb[i].start();
            ppo[i] = new BufferedWriter(new OutputStreamWriter(pip[i].getOutputStream()));
            ppi[i] = new BufferedReader(new InputStreamReader(pip[i].getInputStream()));
            ppe[i] = new BufferedReader(new InputStreamReader(pip[i].getErrorStream()));
            ++i;
        }
        ppo[r.size()] = ous != null ? ous : stdout;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                char[] b = new char[1024];
                int l = 0;
                try {
                    if (ins == null) return;
                    while ((l = ins.read(b)) >= 0) {
                        ppo[0].write(b, 0, l);
                        ppo[0].flush();
                    }
                    IOs.close(ppo[0]);
                    return;
                }
                catch (IOException e) {
                    IOException[] iOExceptionArray = lock;
                    synchronized (lock) {
                        lock[0] = e;
                        lock.notifyAll();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                }
            }
        }).start();
        int ii2 = 0;
        while (ii2 < r.size()) {
            final int i2 = ii2++;
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    char[] b = new char[1024];
                    int l = 0;
                    Writer err0 = err != null ? err : stderr;
                    try {
                        while (true) {
                            if ((l = ppi[i2].read(b)) >= 0) {
                                ppo[i2 + 1].write(b, 0, l);
                                ppo[i2 + 1].flush();
                            } else if (l < 0) {
                                if (i2 < r.size() - 1) {
                                    IOs.close(ppo[i2 + 1]);
                                }
                                ppo[i2 + 1] = null;
                            }
                            l = ppe[i2].read(b);
                            if (l >= 0) {
                                err0.write(b, 0, l);
                                err0.flush();
                            }
                            try {
                                pip[i2].exitValue();
                                if (ppo[i2 + 1] != null) continue;
                                if (i2 != r.size() - 1) return;
                                IOException[] iOExceptionArray = lock;
                                synchronized (lock) {
                                    lock[0] = null;
                                    lock.notifyAll();
                                    // ** MonitorExit[var4_5] (shouldn't be in output)
                                    return;
                                }
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        IOException[] iOExceptionArray = lock;
                        synchronized (lock) {
                            lock[0] = e;
                            lock.notifyAll();
                            // ** MonitorExit[var5_7] (shouldn't be in output)
                            return;
                        }
                    }
                }
            };
            new Thread(run).start();
        }
        try {
            IOException[] ii2 = lock;
            synchronized (lock) {
                lock.wait();
                if (lock[0] != null) {
                    throw lock[0];
                }
                // ** MonitorExit[ii] (shouldn't be in output)
                return pip[r.size() - 1].exitValue();
            }
        }
        catch (InterruptedException e) {
            return Integer.MIN_VALUE;
        }
    }

    public static int runProcess(Iterator<Datum> itr, Map<Symbol, Datum> env, String dir, Reader console) throws IOException {
        int n;
        HashMap<String, String> e2 = new HashMap<String, String>();
        ArrayList<String[]> t = new ArrayList<String[]>();
        ArrayList<String> r = new ArrayList<String>();
        IntegerArrayVector e2o = new IntegerArrayVector();
        BufferedWriter ous = null;
        BufferedWriter err = null;
        Reader ins = console;
        int state = 0;
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (state == 1) {
                ins = new BufferedReader(new InputStreamReader(new FileInputStream(LispUtils.print(d))));
                state = 100;
                continue;
            }
            if (state == 2) {
                ous = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(LispUtils.print(d))));
                state = 100;
                continue;
            }
            if (state == 3) {
                err = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(LispUtils.print(d))));
                state = 100;
                continue;
            }
            if (state == 4) {
                ous = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(LispUtils.print(d), true)));
                state = 100;
                continue;
            }
            if (state == 5) {
                err = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(LispUtils.print(d), true)));
                state = 100;
                continue;
            }
            if (!(d instanceof SymbolName)) {
                if (state == 0) {
                    r.add(LispUtils.print(d));
                    continue;
                }
                throw new ProcessSyntaxException();
            }
            String s = ((SymbolName)((Object)d)).getName();
            if (s.equals("<")) {
                state = 1;
                continue;
            }
            if (s.equals(">")) {
                state = 2;
                continue;
            }
            if (s.equals("2>")) {
                state = 3;
                continue;
            }
            if (s.equals(">>")) {
                state = 4;
                continue;
            }
            if (s.equals("2>>")) {
                state = 5;
                continue;
            }
            if (s.equals("2>&1")) {
                e2o.add(t.size());
                continue;
            }
            if (state == 0 && s.equals("|")) {
                t.add(r.toArray(new String[0]));
                r.clear();
                continue;
            }
            if (state == 0) {
                r.add(s);
                continue;
            }
            throw new ProcessSyntaxException();
        }
        if (env != null) {
            for (Map.Entry<Symbol, Datum> e : env.entrySet()) {
                e2.put(e.getKey().getName(), LispUtils.print(e.getValue()));
            }
        }
        try {
            t.add(r.toArray(new String[0]));
            n = ProcessSubrUtils.execProcess(t, e2, dir, e2o, ins, ous, err);
        }
        catch (Throwable throwable) {
            IOs.close(ins);
            IOs.close(ous);
            IOs.close(err);
            throw throwable;
        }
        IOs.close(ins);
        IOs.close(ous);
        IOs.close(err);
        return n;
    }
}

