/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import java.io.OutputStream;
import net.morilib.lisp.r6rs.io.transcd.AbstractOutputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispErrorHandlingMode;
import net.morilib.util.io.UTF16;

public class UTF16OutputTranscoder
extends AbstractOutputTranscoder {
    private OutputStream ous;
    private LispErrorHandlingMode mode;
    private boolean endian;

    public UTF16OutputTranscoder(OutputStream ous, LispErrorHandlingMode mode, boolean endian) throws IOException {
        this.ous = ous;
        this.mode = mode;
        this.endian = endian;
        if (!endian) {
            ous.write(255);
            ous.write(254);
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (Character.isDefined(c) && c >= 0 && c <= 0x10FFFF) {
            UTF16.write(this.ous, c, this.endian);
        } else {
            int r = this.mode.ifWrite(c, 65533);
            if (r >= 0) {
                UTF16.write(this.ous, r, this.endian);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.ous.flush();
    }

    @Override
    public void close() throws IOException {
        this.ous.close();
    }
}

