/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import java.io.OutputStream;
import net.morilib.lisp.r6rs.io.transcd.AbstractOutputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispErrorHandlingMode;
import net.morilib.util.io.UTF8;

public class UTF8OutputTranscoder
extends AbstractOutputTranscoder {
    private OutputStream ous;
    private LispErrorHandlingMode mode;

    public UTF8OutputTranscoder(OutputStream ous, LispErrorHandlingMode mode) {
        this.ous = ous;
        this.mode = mode;
    }

    @Override
    public void write(int c) throws IOException {
        if (Character.isDefined(c)) {
            UTF8.write(this.ous, c);
        } else {
            int r = this.mode.ifWrite(c, 65533);
            if (r >= 0) {
                UTF8.write(this.ous, r);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.ous.flush();
    }

    @Override
    public void close() throws IOException {
        this.ous.close();
    }
}

