/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.RegexPattern;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;

public class RegexpReplace
extends TernaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        String s = SubrUtils.getString(c2a, mesg);
        String r = SubrUtils.getString(c3a, mesg);
        if (c1a instanceof RegexPattern) {
            Pattern p = ((RegexPattern)c1a).getPattern();
            Matcher m = p.matcher(s);
            return new LispString(m.replaceFirst(r));
        }
        if (c1a instanceof LispString) {
            try {
                Pattern p = Pattern.compile(c1a.getString());
                Matcher m = p.matcher(s);
                return new LispString(m.replaceFirst(r));
            }
            catch (PatternSyntaxException e) {
                throw mesg.getError("err.regexp.regex.syntax", c1a);
            }
        }
        throw mesg.getError("err.regexp.require.regexp", c1a);
    }
}

