/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.serialize;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PushbackInputStream;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispJavaUtils;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.IOs;

public class ImportDatum
extends UnaryArgs {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        Datum datum;
        ObjectInputStream ois = null;
        byte[] pbb = new byte[2];
        try {
            File s = LispFiles.getFile(env, c1a, mesg);
            PushbackInputStream pbs = new PushbackInputStream(new FileInputStream(s));
            if (!IOs.isStreamSerialized(pbs, pbb)) {
                throw mesg.getError("err.serialize.file.notserialized", s.toString());
            }
            ois = new ObjectInputStream(new FileInputStream(s));
            datum = LispJavaUtils.newInstance(ois.readObject());
        }
        catch (IOException e) {
            try {
                throw mesg.getError("err.io", e.getMessage());
                catch (ClassNotFoundException e2) {
                    throw mesg.getError("err.serialize.cannot.serialize");
                }
            }
            catch (Throwable throwable) {
                IOs.close(ois);
                throw throwable;
            }
        }
        IOs.close(ois);
        return datum;
    }
}

