/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sos;

import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.sos.LispClass;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.sos.SlotDatum;

public final class LispObject
extends SlotDatum {
    private LispClass klass;
    private Map<Symbol, Datum> slotval;
    private LispClass nwklass = null;
    private Map<Symbol, Datum> newvals = null;

    LispObject(LispClass cls, Map<Symbol, Datum> initval) {
        super(null);
        this.klass = cls;
        this.slotval = initval;
    }

    LispObject(LispObject obj) {
        super(obj.getName());
        this.klass = obj.klass;
        this.slotval = new HashMap<Symbol, Datum>(obj.slotval);
    }

    void reinstantiate() {
        if (this.nwklass != null) {
            this.slotval = this.nwklass.reinstantiate(this.slotval, this.newvals, this.klass);
            this.klass = this.nwklass;
            this.nwklass = null;
            this.newvals = null;
        }
    }

    void copyFrom(LispObject obj) {
        this.slotval = this.klass.reinstantiate(obj.slotval, this.slotval, obj.klass);
    }

    @Override
    public Datum getSlot(Symbol sym) {
        Datum v;
        if (this.nwklass != null) {
            this.reinstantiate();
        }
        return (v = this.slotval.get(sym)) == null ? this.klass.getSlot0(sym) : v;
    }

    @Override
    public boolean setSlot(Symbol sym, Datum val, LispMessage mesg) {
        if (this.nwklass != null) {
            this.reinstantiate();
        }
        if (this.slotval.containsKey(sym)) {
            this.slotval.put(sym, val);
            return true;
        }
        return this.klass.setSlot0(sym, val);
    }

    void setNewClass(LispClass nwkls, Map<Symbol, Datum> vals) {
        this.nwklass = nwkls;
        this.newvals = vals;
    }

    LispClass getLispClass() {
        return this.klass;
    }

    @Override
    public String display() {
        return "#<" + this.klass.printName() + " " + this.printName() + ">";
    }

    @Override
    public LispType getType() {
        return this.nwklass == null ? this.klass.getObjectType() : this.nwklass.getObjectType();
    }
}

