/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sssp;

import java.io.IOException;
import java.io.Reader;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.sssp.SsspException;
import net.morilib.util.ArrayListStack;

public class SSSPUtils {
    private static final int BUF_SIZE = 1024;

    private static StringBuilder write(Scheme sch, StringBuilder b, int c) {
        b.append((char)c);
        if (b.length() == 1024) {
            sch.exec("(display \"" + b.toString() + "\" out)");
            return new StringBuilder();
        }
        return b;
    }

    private static void flush(Scheme sch, StringBuilder b) {
        if (b.length() > 0) {
            sch.exec("(display \"" + b.toString() + "\" out)");
        }
    }

    public static void parseSssp(Reader rd, Scheme sch) throws IOException {
        int c;
        ArrayListStack<Integer> stk = new ArrayListStack<Integer>();
        StringBuilder bbk = null;
        int state = 0;
        int dpt = -1;
        boolean rte = false;
        boolean txt = false;
        StringBuilder b = new StringBuilder("");
        while ((c = rd.read()) >= 0) {
            switch (state) {
                case 0: {
                    if (c == 60) {
                        state = 20;
                        break;
                    }
                    if (stk.isEmpty()) {
                        SSSPUtils.write(sch, b, c);
                        break;
                    }
                    if (!txt) {
                        b.append("(display \"");
                        b.append((char)c);
                        txt = true;
                        break;
                    }
                    b.append((char)c);
                    break;
                }
                case 20: {
                    if (c == 37) {
                        state = 21;
                        break;
                    }
                    if (stk.isEmpty()) {
                        SSSPUtils.write(sch, b, 60);
                        SSSPUtils.write(sch, b, c);
                        state = 0;
                        break;
                    }
                    if (!txt) {
                        b.append("(display \"<");
                        b.append((char)c);
                        txt = true;
                        state = 0;
                        break;
                    }
                    b.append('<');
                    b.append((char)c);
                    state = 0;
                    break;
                }
                case 21: {
                    if (stk.isEmpty()) {
                        SSSPUtils.flush(sch, b);
                        b = new StringBuilder("");
                    } else if (txt) {
                        b.append("\" out)");
                        txt = false;
                    }
                    if (c == 61) {
                        rte = true;
                        dpt = stk.size();
                        bbk = b;
                        b = new StringBuilder();
                        state = 3;
                        break;
                    }
                    rte = false;
                    state = 3;
                }
                case 3: {
                    if (c == 37) {
                        state = 4;
                        break;
                    }
                    if (c == 34) {
                        state = 301;
                        b.append((char)c);
                        break;
                    }
                    if (c == 35) {
                        state = 311;
                        b.append((char)c);
                        break;
                    }
                    if (c == 40) {
                        stk.push(41);
                        b.append((char)c);
                        break;
                    }
                    if (c == 91) {
                        stk.push(93);
                        b.append((char)c);
                        break;
                    }
                    if (c == 41 || c == 93) {
                        if (stk.isEmpty()) {
                            throw new SsspException();
                        }
                        if ((Integer)stk.pop() != c) {
                            throw new SsspException();
                        }
                        b.append((char)c);
                        break;
                    }
                    b.append((char)c);
                    break;
                }
                case 301: {
                    if (c == 92) {
                        state = 302;
                    } else if (c == 34) {
                        state = 3;
                    }
                    b.append((char)c);
                    break;
                }
                case 302: {
                    state = 301;
                    b.append((char)c);
                    break;
                }
                case 311: {
                    state = c == 92 ? 312 : (c == 47 ? 313 : (c == 91 ? 314 : (c == 82 ? 315 : 3)));
                    b.append((char)c);
                    break;
                }
                case 312: {
                    state = 3;
                    b.append((char)c);
                    break;
                }
                case 313: {
                    if (c == 47) {
                        state = 3;
                    }
                    b.append((char)c);
                    break;
                }
                case 314: {
                    if (c == 93) {
                        state = 3;
                    }
                    b.append((char)c);
                    break;
                }
                case 315: {
                    state = c == 91 || c == 40 ? 316 : 3;
                    b.append((char)c);
                    break;
                }
                case 316: {
                    if (c == 93 || c == 41) {
                        state = 3;
                    }
                    b.append((char)c);
                    break;
                }
                case 4: {
                    if (c == 62) {
                        if (rte) {
                            if (dpt != stk.size()) {
                                throw new SsspException();
                            }
                            if (stk.isEmpty()) {
                                sch.exec("(display " + b.toString() + " out)");
                                b = new StringBuilder("");
                            } else {
                                bbk.append("(display ");
                                bbk.append((CharSequence)b);
                                bbk.append(" out)");
                                b = bbk;
                            }
                        } else if (stk.isEmpty()) {
                            sch.exec(b.toString());
                            b = new StringBuilder("");
                        }
                        state = 0;
                        break;
                    }
                    b.append('%');
                    b.append(c);
                    state = 3;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        switch (state) {
            case 0: {
                SSSPUtils.flush(sch, b);
                break;
            }
            case 20: {
                b.append('<');
                SSSPUtils.flush(sch, b);
                break;
            }
            default: {
                throw new SsspException();
            }
        }
    }
}

