/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.UnaryArgs;

public class Angle
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispComplex) {
            LispComplex n = (LispComplex)c1a;
            if (n.isNaN()) {
                return LispDouble.NaN;
            }
            if (n.isReal()) {
                double r = n.getRealDouble();
                if (r >= 0.0) {
                    return LispDouble.ZERO;
                }
                return new LispDouble(Math.PI);
            }
            return new LispDouble(Math.atan2(n.getImagDouble(), n.getRealDouble()));
        }
        throw mesg.getError("err.require.complex", c1a);
    }
}

