/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;

public class Atan
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() == 1) {
            Datum d = lst.get(0);
            if (d instanceof LispComplex) {
                return LispMath.atan((LispComplex)d);
            }
            throw mesg.getError("err.require.complex", d);
        }
        if (lst.size() == 2) {
            Datum d1 = lst.get(0);
            Datum d2 = lst.get(1);
            if (!(d1 instanceof LispComplex)) {
                throw mesg.getError("err.require.real", d1);
            }
            if (!(d2 instanceof LispComplex)) {
                throw mesg.getError("err.require.real", d2);
            }
            LispComplex n1 = (LispComplex)d1;
            LispComplex n2 = (LispComplex)d2;
            if (n1.isReal() && n2.isReal()) {
                return new LispDouble(Math.atan2(n1.getRealDouble(), n2.getRealDouble()));
            }
            if (!n1.isReal()) {
                throw mesg.getError("err.require.real", n1);
            }
            throw mesg.getError("err.require.real", n2);
        }
        throw mesg.getError("err.argument", "atan");
    }
}

