/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.ILispComponent;
import net.morilib.lisp.swing.ILispComposite;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;

public class LayoutBorder
extends Subr {
    private static final OneToOneSet<Symbol, String> _DIRECT = new HashOneToOneSet<Symbol, String>({Symbol.getSymbol("center"), "Center"}, {Symbol.getSymbol("north"), "North"}, {Symbol.getSymbol("south"), "South"}, {Symbol.getSymbol("east"), "East"}, {Symbol.getSymbol("west"), "West"});

    private BorderLayout createbl(Container cmp, Datum d0, LispMessage mesg) {
        BorderLayout bl = new BorderLayout();
        ConsIterator itr = new ConsIterator(d0);
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!(d instanceof Cons)) continue;
            Cons c = (Cons)d;
            if (!(c.getCdr() instanceof ILispComponent)) {
                throw mesg.getError("err.swing.require.component", c.getCdr());
            }
            String s = (String)_DIRECT.getValue(c.getCar());
            if (s == null) {
                throw mesg.getError("err.swing.invaliddirection", c.getCar());
            }
            cmp.add((Component)((ILispComponent)((Object)c.getCdr())).getComponent(), s);
        }
        return bl;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() == 2) {
            if (!(l.get(0) instanceof ILispComposite)) {
                throw mesg.getError("err.swing.require.composite", l.get(0));
            }
            BorderLayout bl = this.createbl(((ILispComposite)((Object)l.get(0))).getPane(), l.get(1), mesg);
        } else if (l.size() == 4) {
            int hg = SubrUtils.getSmallInt(l.get(1), mesg);
            int vg = SubrUtils.getSmallInt(l.get(2), mesg);
            if (!(l.get(0) instanceof ILispComposite)) {
                throw mesg.getError("err.swing.require.composite", l.get(0));
            }
            BorderLayout bl = this.createbl(((ILispComposite)((Object)l.get(0))).getPane(), l.get(1), mesg);
            bl.setHgap(hg);
            bl.setVgap(vg);
        } else {
            throw mesg.getError("err.argument", body);
        }
        return Undef.UNDEF;
    }
}

