/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.ILispComponent;
import net.morilib.lisp.swing.ILispComposite;

public class LayoutGroup
extends BinaryArgs {
    private static final Symbol VGAP = Symbol.getSymbol("vertical");
    private static final Symbol HGAP = Symbol.getSymbol("horizontal");

    private GroupLayout.Group parseVGroup(Datum c2a, GroupLayout g, LispMessage m) {
        GroupLayout.SequentialGroup gs = g.createSequentialGroup();
        int cnt = -1;
        ConsIterator itr = new ConsIterator(c2a);
        while (itr.hasNext()) {
            GroupLayout.ParallelGroup gp = g.createParallelGroup();
            ConsIterator jtr = new ConsIterator(itr.next());
            int j = 0;
            while (jtr.hasNext()) {
                Datum d = jtr.next();
                if (d instanceof ILispComponent) {
                    ((GroupLayout.Group)gp).addComponent(((ILispComponent)((Object)d)).getComponent());
                } else if (!(d instanceof LispVector)) {
                    ((GroupLayout.Group)gp).addGroup(this.parseVGroup(d, g, m));
                } else {
                    int i3;
                    int i2;
                    int i1;
                    int i0 = ((LispVector)d).getList().indexOf(VGAP);
                    if (i0 < 0) {
                        i1 = -2;
                        i2 = -2;
                        i3 = -2;
                    } else {
                        if (((LispVector)d).size() < i0 + 4) {
                            throw m.getError("err.swing.invalidlayout.group", c2a);
                        }
                        Datum g1 = ((LispVector)d).get(i0 + 1);
                        Datum g2 = ((LispVector)d).get(i0 + 2);
                        Datum g3 = ((LispVector)d).get(i0 + 3);
                        i1 = SubrUtils.getSmallInt(g1, m);
                        i2 = SubrUtils.getSmallInt(g2, m);
                        i3 = SubrUtils.getSmallInt(g3, m);
                    }
                    Datum v = ((LispVector)d).get(0);
                    if (v instanceof Symbol) {
                        if (i1 == -2) {
                            throw m.getError("err.swing.invalidlayout.group", c2a);
                        }
                        ((GroupLayout.Group)gp).addGap(i1, i2, i3);
                    } else if (v instanceof ILispComponent) {
                        ((GroupLayout.Group)gp).addComponent(((ILispComponent)((Object)v)).getComponent(), i1, i2, i3);
                    } else {
                        throw m.getError("err.swing.invalidlayout.group", c2a);
                    }
                }
                ++j;
            }
            if (cnt < 0) {
                cnt = j;
            } else if (cnt != j) {
                throw m.getError("err.swing.invalidlayout.group", c2a);
            }
            ((GroupLayout.Group)gs).addGroup(gp);
            SubrUtils.checkProper(jtr, c2a, m);
        }
        SubrUtils.checkProper(itr, c2a, m);
        return gs;
    }

    private GroupLayout.Group parseHGroup(Datum c2a, GroupLayout g, LispMessage m) {
        GroupLayout.SequentialGroup gs = g.createSequentialGroup();
        int cnt = -1;
        ArrayList lst = new ArrayList();
        ConsIterator itr = new ConsIterator(c2a);
        while (itr.hasNext()) {
            ConsIterator jtr = new ConsIterator(itr.next());
            int j = 0;
            while (jtr.hasNext()) {
                Datum d;
                if (cnt < 0) {
                    lst.add(new ArrayList());
                }
                if ((d = jtr.next()) instanceof ILispComponent) {
                    ((List)lst.get(j)).add(((ILispComponent)((Object)d)).getComponent());
                } else if (!(d instanceof LispVector)) {
                    ((List)lst.get(j)).add(this.parseHGroup(d, g, m));
                } else {
                    ((List)lst.get(j)).add(d);
                }
                ++j;
            }
            if (cnt < 0) {
                cnt = j;
            } else if (cnt != j) {
                throw m.getError("err.swing.invalidlayout.group", c2a);
            }
            SubrUtils.checkProper(jtr, c2a, m);
        }
        SubrUtils.checkProper(itr, c2a, m);
        for (List list : lst) {
            GroupLayout.ParallelGroup gp = g.createParallelGroup();
            for (Object l2 : list) {
                if (l2 instanceof LispVector) {
                    int i3;
                    int i2;
                    int i1;
                    int i0 = ((LispVector)l2).getList().indexOf(HGAP);
                    if (i0 < 0) {
                        i1 = -2;
                        i2 = -2;
                        i3 = -2;
                    } else {
                        if (((LispVector)l2).size() < i0 + 4) {
                            throw m.getError("err.swing.invalidlayout.group", c2a);
                        }
                        Datum g1 = ((LispVector)l2).get(1);
                        Datum g2 = ((LispVector)l2).get(2);
                        Datum g3 = ((LispVector)l2).get(3);
                        i1 = SubrUtils.getSmallInt(g1, m);
                        i2 = SubrUtils.getSmallInt(g2, m);
                        i3 = SubrUtils.getSmallInt(g3, m);
                    }
                    Datum v = ((LispVector)l2).get(0);
                    if (v instanceof Symbol) {
                        if (i1 == -2) {
                            throw m.getError("err.swing.invalidlayout.group", c2a);
                        }
                        ((GroupLayout.Group)gp).addGap(i1, i2, i3);
                        continue;
                    }
                    if (v instanceof ILispComponent) {
                        ((GroupLayout.Group)gp).addComponent(((ILispComponent)((Object)v)).getComponent(), i1, i2, i3);
                        continue;
                    }
                    throw m.getError("err.swing.invalidlayout.group", c2a);
                }
                if (l2 instanceof GroupLayout.Group) {
                    ((GroupLayout.Group)gp).addGroup((GroupLayout.Group)l2);
                    continue;
                }
                if (l2 instanceof Component) {
                    ((GroupLayout.Group)gp).addComponent((Component)l2);
                    continue;
                }
                throw new RuntimeException();
            }
            ((GroupLayout.Group)gs).addGroup(gp);
        }
        return gs;
    }

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof ILispComposite)) {
            throw mesg.getError("err.swing.require.composite", c1a);
        }
        Container c = ((ILispComposite)((Object)c1a)).getPane();
        GroupLayout l = new GroupLayout(c);
        c.setLayout(l);
        l.setVerticalGroup(this.parseVGroup(c2a, l, mesg));
        l.setHorizontalGroup(this.parseHGroup(c2a, l, mesg));
        return Undef.UNDEF;
    }
}

