/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.painter.SchlushPanelFrame;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.swing.ILispComponent;

public class LispCanvas
extends SchlushPanelFrame
implements ILispComponent {
    private JPanel panel = super.createPanel();

    private LispCanvas() {
    }

    private LispCanvas(CoordinateMap coordinate) {
        super(coordinate);
    }

    @Override
    public JPanel createPanel() {
        throw new RuntimeException("panels cannot be created");
    }

    @Override
    public int getImageWidth(Image img) {
        return img.getWidth(this.panel);
    }

    @Override
    public int getImageHeight(Image img) {
        return img.getHeight(this.panel);
    }

    @Override
    public int getHeight() {
        return this.panel.getHeight();
    }

    @Override
    public int getWidth() {
        return this.panel.getWidth();
    }

    @Override
    public void repaint() {
        this.panel.repaint();
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    protected void loadImage(Image img) throws InterruptedException {
        MediaTracker mt = new MediaTracker(this.panel);
        mt.addImage(img, 1);
        mt.waitForAll();
    }

    @Override
    public Component getAWTComponent() {
        return this.getComponent();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<canvas>");
    }

    /* synthetic */ LispCanvas(LispCanvas lispCanvas) {
        this();
    }

    /* synthetic */ LispCanvas(CoordinateMap coordinateMap, LispCanvas lispCanvas) {
        this(coordinateMap);
    }

    public static class MakeCanvas
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 0) {
                return new LispCanvas(null);
            }
            if (l.size() == 4) {
                double x1 = l.get(0).getRealDouble();
                double y1 = l.get(1).getRealDouble();
                double x2 = l.get(2).getRealDouble();
                double y2 = l.get(3).getRealDouble();
                return new LispCanvas(new CoordinateMap(x1, y1, x2, y2), null);
            }
            throw mesg.getError("err.argument", body);
        }
    }
}

