/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.ILispButton;
import net.morilib.lisp.swing.LightweightGUIElement;

public class LispCheckBox
extends LightweightGUIElement
implements ILispButton {
    private JCheckBox checkbox;

    public LispCheckBox(JCheckBox checkbox) {
        this.checkbox = checkbox;
    }

    @Override
    public Component getAWTComponent() {
        return this.checkbox;
    }

    @Override
    public AbstractButton getComponent() {
        return this.checkbox;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<checkbox>");
    }

    public static class IsCheckboxChecked
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispCheckBox) {
                return LispBoolean.getInstance(((LispCheckBox)c1a).checkbox.isSelected());
            }
            throw mesg.getError("err.swing.require.checkbox", c1a);
        }
    }

    public static class MakeCheckbox
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispString) {
                return new LispCheckBox(new JCheckBox(c1a.getString()));
            }
            throw mesg.getError("err.require.string", c1a);
        }
    }

    public static class SetCheckboxCheckedS
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispCheckBox) {
                ((LispCheckBox)c1a).checkbox.setSelected(c2a.isTrue());
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.checkbox", c1a);
        }
    }
}

