/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.LightweightGUIElement;

public class LispJTable
extends LightweightGUIElement {
    JTable table;

    public LispJTable(JTable table) {
        this.table = table;
    }

    static JTable makeTable(Datum d, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(d);
        final ArrayList<List<Datum>> mdl = new ArrayList<List<Datum>>();
        final int[] cl = new int[]{0};
        while (itr.hasNext()) {
            List<Datum> l = LispUtils.consToList(itr.next(), mesg);
            mdl.add(l);
            if (l.size() <= cl[0]) continue;
            cl[0] = l.size();
        }
        SubrUtils.checkProper(itr, d, mesg);
        return new JTable(new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return mdl.size();
            }

            @Override
            public int getColumnCount() {
                return cl[0];
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (row < 1 || row > this.getRowCount()) {
                    return null;
                }
                if (col < 1 || col > this.getColumnCount()) {
                    return null;
                }
                if (col > ((List)mdl.get(row - 1)).size()) {
                    return null;
                }
                return ((List)mdl.get(row - 1)).get(col - 1);
            }
        });
    }

    @Override
    public JComponent getComponent() {
        return this.table;
    }

    @Override
    public Component getAWTComponent() {
        return this.table;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<gui-table>");
    }
}

