/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.system;

import net.morilib.lang.system.Version;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.system.LispVersion;

public class IsVersionSuper
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Version v = null;
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (d instanceof LispVersion) {
                if (v != null && !v.isVersionOf(((LispVersion)d).ver)) {
                    return LispBoolean.FALSE;
                }
                v = ((LispVersion)d).ver;
                continue;
            }
            throw mesg.getError("err.system.require.version", d);
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        return LispBoolean.TRUE;
    }
}

