/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.topology;

import net.morilib.lisp.Datum2;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispIntersection;
import net.morilib.lisp.topology.LispUnion;

public abstract class AbstractLispTopology
extends Datum2
implements ILispTopology {
    private Boolean isContained0(ILispTopology t) {
        if (t.isEmpty()) {
            return false;
        }
        if (t.isUniverse()) {
            return true;
        }
        if (t instanceof LispIntersection) {
            ILispTopology[] iLispTopologyArray = ((LispIntersection)t).topologies;
            int n = ((LispIntersection)t).topologies.length;
            int n2 = 0;
            while (n2 < n) {
                ILispTopology s = iLispTopologyArray[n2];
                if (!s.isContained(t)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return null;
    }

    private Boolean isIndependent0(ILispTopology t) {
        if (t.isEmpty()) {
            return true;
        }
        if (t.isUniverse()) {
            return false;
        }
        if (t instanceof LispUnion) {
            ILispTopology[] iLispTopologyArray = ((LispUnion)t).topologies;
            int n = ((LispUnion)t).topologies.length;
            int n2 = 0;
            while (n2 < n) {
                ILispTopology s = iLispTopologyArray[n2];
                if (!s.isIndependent(t)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return null;
    }

    @Override
    public boolean isContained(ILispTopology t) {
        Boolean b = this.isContained0(t);
        return b != null && b != false;
    }

    @Override
    public boolean isIndependent(ILispTopology t) {
        Boolean b = this.isIndependent0(t);
        return b != null && b != false;
    }

    @Override
    public boolean isNotContained(ILispTopology t) {
        if (this.isContained(t)) {
            return false;
        }
        Boolean b = this.isContained0(t);
        if (b != null) {
            return b == false;
        }
        return false;
    }

    @Override
    public boolean isNotIndependent(ILispTopology t) {
        if (this.isIndependent(t)) {
            return false;
        }
        Boolean b = this.isIndependent0(t);
        if (b != null) {
            return b == false;
        }
        return false;
    }

    private boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    @Override
    public ILispTopology unionTopology(ILispTopology t) {
        if (t.isEmpty()) {
            return this;
        }
        if (t.isUniverse()) {
            return t;
        }
        if (this.isTrue(this.isContained(t))) {
            return t;
        }
        if (t.isContained(this)) {
            return this;
        }
        return LispUnion.newInstance(this, t);
    }

    @Override
    public ILispTopology intersectionTopology(ILispTopology t) {
        if (t.isEmpty()) {
            return t;
        }
        if (t.isUniverse()) {
            return this;
        }
        if (this.isTrue(this.isContained(t))) {
            return this;
        }
        if (t.isContained(this)) {
            return t;
        }
        return LispIntersection.newInstance(this, t);
    }
}

