/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.util;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.morilib.lisp.util.LispHandler;
import net.morilib.lisp.util.NullHandler;

public class LogEnv {
    private static final String PGM_ID = "SCHLUSH";
    private static final Formatter FMTER = new SimpleFormatter();
    private static String PATTERN;
    private static Handler theHandler;

    static {
        try {
            String pat = System.getProperty("mylog.logfile.pattern");
            String ept = System.getenv("SCHLUSH_LOG");
            PATTERN = pat != null ? pat : (ept != null ? ept : null);
        }
        catch (AccessControlException e) {
            PATTERN = null;
        }
    }

    public static synchronized Logger init(String name) {
        Logger res = Logger.getLogger(name);
        try {
            Handler[] hns;
            Handler[] handlerArray = hns = res.getHandlers();
            int n = hns.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                res.removeHandler(h);
                ++n2;
            }
            if (theHandler == null) {
                if (PATTERN != null) {
                    theHandler = new LispHandler(PATTERN);
                    theHandler.setFormatter(FMTER);
                } else {
                    theHandler = new NullHandler();
                }
            }
            res.addHandler(theHandler);
            res.setLevel(PATTERN != null ? Level.ALL : Level.OFF);
            return res;
        }
        catch (AccessControlException e) {
            return res;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

