/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousUnsignedArray;
import net.morilib.util.Bytes;
import net.morilib.util.primitive.LongArrayVector;
import net.morilib.util.uvector.LongArray;

public class LispU64Vector
extends Atom
implements HomogeneousUnsignedArray,
Serializable {
    private LongArray vector;

    private LispU64Vector() {
    }

    public LispU64Vector(long ... bs) {
        this.vector = LongArray.newArray(bs);
    }

    public static LispU64Vector malloc(int size) {
        LispU64Vector res = new LispU64Vector();
        res.vector = LongArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        if (!(d instanceof LispReal)) {
            return false;
        }
        return ((LispReal)d).inUnsignedLongRange();
    }

    private static long[] toLongList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        LongArrayVector v = new LongArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispU64Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.u64", d);
            }
            v.add(d.getLong());
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toLongArray();
    }

    @Override
    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#u64(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append(Bytes.ulongToBigInteger(this.vector.getLong(i)));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public String getResult() {
        return this.print();
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.print());
    }

    @Override
    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispU64Vector)) {
            return false;
        }
        if (!(d2 instanceof LispU64Vector)) {
            return false;
        }
        return ((LispU64Vector)d1).vector.equals(((LispU64Vector)d2).vector);
    }

    @Override
    public LispReal get(int index) {
        return LispInteger.valueOf(Bytes.ulongToBigInteger(this.vector.getLong(index)));
    }

    @Override
    public void set(int index, LispReal x) {
        this.vector.setLong(index, x.getLong());
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispU64Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.u64", x);
        }
    }

    @Override
    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    @Override
    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    @Override
    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    public static class EqualU64Vector
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispU64Vector)) {
                throw mesg.getError("err.uvector.require.u64", c1a);
            }
            if (!(c2a instanceof LispU64Vector)) {
                throw mesg.getError("err.uvector.require.u64", c2a);
            }
            return LispBoolean.getInstance(((LispU64Vector)c1a).vector.equals(((LispU64Vector)c2a).vector));
        }
    }

    public static class IsU64Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispU64Vector);
        }
    }

    public static class ListToU64Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispU64Vector(LispU64Vector.toLongList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeU64Vector
    extends Subr {
        private long[] makeVector(int len, BigInteger d) {
            LongArrayVector b = new LongArrayVector();
            int i = 0;
            while (i < len) {
                b.add(d.longValue());
                ++i;
            }
            return b.toLongArray();
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispU64Vector(this.makeVector(t, BigInteger.ZERO));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispU64Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.u64", lst.get(1));
                }
                return new LispU64Vector(this.makeVector(t, lst.get(1).getBigInteger()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class U64Vector
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispU64Vector(LispU64Vector.toLongList(body, mesg));
        }
    }

    public static class U64VectorToList
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispU64Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispU64Vector v = (LispU64Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(LispInteger.valueOf(Bytes.ulongToBigInteger(v.vector.getLong(i))));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.u64", c1a);
        }
    }
}

