/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.zip;

import java.io.IOException;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.r6rs.io.LispInputStreamPort;
import net.morilib.lisp.r6rs.io.LispTextualInputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispBufferMode;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.zip.LispZipEntry;
import net.morilib.lisp.zip.LispZipFile;
import net.morilib.util.Iterators;

public class ZipFileInputPort
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ZipEntry ze;
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum bm = Iterators.nextIf(itr, LispBufferMode.BLOCK);
        Datum tr = Iterators.nextIf(itr, LispBoolean.FALSE);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(c1a instanceof LispZipFile)) {
            throw mesg.getError("err.zip.require.zipfile", c1a);
        }
        if (!(bm instanceof LispBufferMode)) {
            throw mesg.getError("err.io.require.buffermode", bm);
        }
        if (tr.isTrue() && !(tr instanceof ILispTranscoder)) {
            throw mesg.getError("err.io.require.transcoder", tr);
        }
        ZipFile zf = ((LispZipFile)c1a).zipfile;
        if (c2a instanceof LispZipEntry) {
            ze = ((LispZipEntry)c2a).entry;
        } else {
            ze = zf.getEntry(SubrUtils.getString(c2a, mesg));
            if (ze == null) {
                throw mesg.getError("err.zip.entry.notfound", c2a);
            }
        }
        try {
            if (tr.isTrue()) {
                return new LispTextualInputPort(((ILispTranscoder)((Object)tr)).newInput(zf.getInputStream(ze)), (ILispTranscoder)((Object)tr));
            }
            return new LispInputStreamPort(zf.getInputStream(ze));
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

