/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.constants;

import net.morilib.lang.number.Rational;
import net.morilib.math.constants.AlternatingSeriesNumber;
import net.morilib.math.series.PiMachinSeries;

public class Pi
extends AlternatingSeriesNumber {
    public static final Pi PI = new Pi(Rational.ONE, Rational.ZERO);
    public static final Pi ONE_DEGREE = new Pi(Rational.valueOf(180).invert(), Rational.ZERO);

    public Pi(Rational scale, Rational shift) {
        super(PiMachinSeries.FACTORY, scale, shift);
    }

    public int hashCode() {
        return this.scale.hashCode() + 72;
    }

    public boolean equals(Object o) {
        return o instanceof Pi && this.scale.equals(((Pi)o).scale);
    }

    public String toString() {
        String sh = this.shift.isZero() ? "" : (this.shift.signum() > 0 ? "+" + this.shift : "" + this.shift);
        return this.scale.isUnit() ? "pi" + sh : this.scale + "pi" + sh;
    }
}

