/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.morilib.lang.algebra.FieldElement;
import net.morilib.math.functions.Polynomial1Coefficients;

public class ListPolynomial1Coefficients<C extends FieldElement<C>>
extends Polynomial1Coefficients<C>
implements Serializable {
    private static final long serialVersionUID = 7431581179968261833L;
    private List<C> coefficients;

    public ListPolynomial1Coefficients(C c) {
        this.coefficients = new ArrayList<C>();
        this.coefficients.add(c);
    }

    private ListPolynomial1Coefficients(int n) {
        this.coefficients = new ArrayList<C>(n);
    }

    private ListPolynomial1Coefficients(ListPolynomial1Coefficients<C> d) {
        this.coefficients = new ArrayList<C>(d.coefficients);
    }

    @Override
    public C getCoefficient(int n) {
        return (C)((FieldElement)this.coefficients.get(n));
    }

    @Override
    protected void setCoefficient(int n, C v) {
        if (v.isZero()) {
            this.coefficients.set(n, null);
        } else {
            this.coefficients.set(n, v);
        }
    }

    @Override
    protected Iterator<Integer> indexIterator() {
        int s0 = 0;
        while (s0 < this.coefficients.size() && this.coefficients.get(s0) == null) {
            ++s0;
        }
        int si = s0;
        return new Iterator<Integer>(si){
            private int i;
            {
                this.i = n;
            }

            @Override
            public boolean hasNext() {
                return this.i < ListPolynomial1Coefficients.this.coefficients.size();
            }

            @Override
            public Integer next() {
                int ri = this.i;
                while (this.i < ListPolynomial1Coefficients.this.coefficients.size() && ListPolynomial1Coefficients.this.coefficients.get(this.i) == null) {
                    ++this.i;
                }
                return ri;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int deg() {
        int s0 = this.coefficients.size() - 1;
        while (s0 >= 0 && this.coefficients.get(s0) == null) {
            --s0;
        }
        return s0;
    }

    @Override
    protected Polynomial1Coefficients<C> newInstance(int size) {
        if (size < 0) {
            return new ListPolynomial1Coefficients<C>(0);
        }
        return new ListPolynomial1Coefficients<C>(size + 1);
    }

    @Override
    public Polynomial1Coefficients<C> duplicate() {
        return new ListPolynomial1Coefficients<C>(this);
    }
}

