/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.functions;

import java.util.ArrayList;
import java.util.Iterator;
import net.morilib.lang.algebra.FieldElement;
import net.morilib.lang.algebra.QuotientAndRemainder;
import net.morilib.lang.algebra.Remainderable;
import net.morilib.lang.algebra.RingElement;

public abstract class Polynomial1Coefficients<C extends FieldElement<C>>
implements RingElement<Polynomial1Coefficients<C>>,
Remainderable<Polynomial1Coefficients<C>> {
    protected abstract C getCoefficient(int var1);

    protected abstract void setCoefficient(int var1, C var2);

    protected abstract Iterator<Integer> indexIterator();

    public abstract int deg();

    protected abstract Polynomial1Coefficients<C> newInstance(int var1);

    public abstract Polynomial1Coefficients<C> duplicate();

    public boolean isUnit() {
        return this.deg() == 0 && this.getCoefficient(0).isUnit();
    }

    @Override
    public Polynomial1Coefficients<C> divide(Polynomial1Coefficients<C> x) {
        return this.divideAndRemainder(x).getQuotient();
    }

    @Override
    public Polynomial1Coefficients<C> negate() {
        Iterator<Integer> itr = this.indexIterator();
        Polynomial1Coefficients<FieldElement> res = this.duplicate();
        while (itr.hasNext()) {
            int i = itr.next();
            res.setCoefficient(i, (FieldElement)this.getCoefficient(i).negate());
        }
        return res;
    }

    @Override
    public Polynomial1Coefficients<C> multiply(Polynomial1Coefficients<C> x) {
        Iterator<Integer> itr = x.indexIterator();
        Polynomial1Coefficients<C> res = this.newInstance(this.deg() + x.deg());
        while (itr.hasNext()) {
            Iterator<Integer> jtr = this.indexIterator();
            int i = itr.next();
            C ci = x.getCoefficient(i);
            while (jtr.hasNext()) {
                int j = jtr.next();
                C cj = this.getCoefficient(j);
                Object cr = res.getCoefficient(j);
                cr = cr == null ? (FieldElement)cj.multiply(ci) : cr.add((FieldElement)((FieldElement)cj.multiply(ci)));
                res.setCoefficient(i + j, cr);
            }
        }
        return res;
    }

    @Override
    public Polynomial1Coefficients<C> power(int n) {
        if (n == 0) {
            return this.newInstance(-1);
        }
        if (n == 1) {
            return this;
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Polynomial1Coefficients<Polynomial1Coefficients<C>> res = this.duplicate();
        int i = 2;
        while (i < n) {
            res = res.multiply((Polynomial1Coefficients<C>)res);
            ++i;
        }
        return res;
    }

    @Override
    public Polynomial1Coefficients<C> subtract(Polynomial1Coefficients<C> x) {
        Iterator<Integer> itr = this.indexIterator();
        Polynomial1Coefficients<FieldElement> res = x.duplicate();
        while (itr.hasNext()) {
            int i = itr.next();
            C c = x.getCoefficient(i);
            if (c == null) continue;
            res.setCoefficient(i, (FieldElement)this.getCoefficient(i).subtract(c));
        }
        return res;
    }

    @Override
    public Polynomial1Coefficients<C> add(Polynomial1Coefficients<C> x) {
        Iterator<Integer> itr = this.indexIterator();
        Polynomial1Coefficients<FieldElement> res = x.duplicate();
        while (itr.hasNext()) {
            int i = itr.next();
            C c = x.getCoefficient(i);
            if (c == null) continue;
            res.setCoefficient(i, (FieldElement)this.getCoefficient(i).add(c));
        }
        return res;
    }

    @Override
    public Polynomial1Coefficients<C> multiply(int n) {
        Iterator<Integer> itr = this.indexIterator();
        Polynomial1Coefficients<FieldElement> res = this.duplicate();
        while (itr.hasNext()) {
            int i = itr.next();
            res.setCoefficient(i, (FieldElement)this.getCoefficient(i).multiply(n));
        }
        return res;
    }

    @Override
    public Polynomial1Coefficients<C> multiply(C c) {
        Iterator<Integer> itr = this.indexIterator();
        Polynomial1Coefficients<FieldElement> res = this.duplicate();
        while (itr.hasNext()) {
            int i = itr.next();
            res.setCoefficient(i, (FieldElement)this.getCoefficient(i).multiply(c));
        }
        return res;
    }

    @Override
    public Polynomial1Coefficients<C> remainder(Polynomial1Coefficients<C> x) {
        return this.divideAndRemainder(x).getRemainder();
    }

    @Override
    public QuotientAndRemainder<Polynomial1Coefficients<C>> divideAndRemainder(Polynomial1Coefficients<C> x) {
        Polynomial1Coefficients<C> r = this.duplicate();
        if (this.deg() < x.deg()) {
            return new QuotientAndRemainder<Polynomial1Coefficients<C>>(this.newInstance(-1), x);
        }
        Polynomial1Coefficients<FieldElement> q = this.newInstance(this.deg() - x.deg());
        int k = this.deg() - x.deg();
        while (k >= 0) {
            Iterator<Integer> jtr = x.indexIterator();
            FieldElement qk = (FieldElement)r.getCoefficient(k + x.deg()).divide(x.getCoefficient(x.deg()));
            q.setCoefficient(k, qk);
            while (jtr.hasNext()) {
                int j = jtr.next() + k;
                Object uj = r.getCoefficient(j);
                C vjk = x.getCoefficient(j - k);
                uj = uj.subtract((FieldElement)((FieldElement)qk.multiply(vjk)));
                r.setCoefficient(j, uj);
            }
            --k;
        }
        return new QuotientAndRemainder<Polynomial1Coefficients<C>>(q, r);
    }

    @Override
    public boolean isZero() {
        return this.deg() < 0;
    }

    public Polynomial1Coefficients<C> differenciate() {
        Iterator<Integer> itr = this.indexIterator();
        Polynomial1Coefficients<FieldElement> q = this.newInstance(this.deg() - 1);
        while (itr.hasNext()) {
            int i = itr.next();
            if (i <= 0) continue;
            q.setCoefficient(i - 1, (FieldElement)q.getCoefficient(i).multiply(i));
        }
        return q;
    }

    public Polynomial1Coefficients<C> substitute(Polynomial1Coefficients<C> x) {
        Iterator<Integer> itr = this.indexIterator();
        Polynomial1Coefficients<C> r = this.newInstance(-1);
        while (itr.hasNext()) {
            int i = itr.next();
            r = r.add(((Polynomial1Coefficients)x.power(i)).multiply(this.getCoefficient(i)));
        }
        return r;
    }

    public int hashCode() {
        Iterator<Integer> itr = this.indexIterator();
        int r = 17;
        while (itr.hasNext()) {
            r = 37 * (r + this.getCoefficient(itr.next()).hashCode());
        }
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Polynomial1Coefficients) {
            Polynomial1Coefficients p = (Polynomial1Coefficients)obj;
            Iterator<Integer> itr = this.indexIterator();
            while (itr.hasNext()) {
                int i = itr.next();
                C c1 = this.getCoefficient(i);
                C c2 = p.getCoefficient(i);
                if (c2 != null && c1.equals(c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(String var) {
        StringBuilder b = new StringBuilder();
        Iterator<Integer> itr = this.indexIterator();
        String d = "";
        ArrayList<Integer> l = new ArrayList<Integer>();
        while (itr.hasNext()) {
            l.add(itr.next());
        }
        int j = l.size() - 1;
        while (j >= 0) {
            int i = (Integer)l.get(j);
            b.append(d);
            b.append(this.getCoefficient(i).toString());
            if (i > 0) {
                b.append(var).append("^");
                b.append(i);
            }
            d = " + ";
            --j;
        }
        return b.toString();
    }

    public String toString() {
        return this.toString("x");
    }
}

