/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.series;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import net.morilib.lang.number.Rational;
import net.morilib.math.Math3;

public class SqrtSeries
implements Iterator<Rational> {
    private Iterator<BigDecimal> iter;
    private BigDecimal bef;
    private boolean stat = false;
    private int sc = 0;

    public SqrtSeries(Iterator<BigDecimal> iter) {
        this.iter = iter;
        this.bef = iter.next();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Rational next() {
        BigDecimal r;
        BigDecimal d1 = this.iter.next();
        BigDecimal dd = this.bef.subtract(d1);
        if (dd.signum() != 0) {
            this.sc = 0;
            while (dd.intValue() == 0) {
                dd = dd.movePointRight(1);
                ++this.sc;
            }
        } else {
            this.sc += 3;
        }
        BigDecimal bigDecimal = r = this.sc > 0 ? Math3.sqrtDecimal(d1, --this.sc) : d1;
        if (this.stat) {
            r = r.add(new BigDecimal(BigInteger.ONE, this.sc));
        }
        this.stat = !this.stat;
        this.bef = d1;
        return Rational.valueOf(r);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

