/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.special;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.morilib.lang.transform.DoubleSequence;

public class ZetaFunctions {
    private static final String ZETA_INTEGER = "zetainteger.txt";
    public static final DoubleSequence RIEMANN_ZETA_SEQUENCE = new _ZInt();
    public static final DoubleSequence RIEMANN_ZETA_MINUS1_SEQUENCE = new _ZIntMinus1();

    static double calculateZ(int n) {
        double r = 0.0;
        double rold = Double.MAX_VALUE;
        int p = 2;
        while (Math.abs(r - rold) > Double.MIN_VALUE) {
            rold = r;
            r += 1.0 / Math.pow(p, n);
            ++p;
        }
        return r;
    }

    static class _ZInt
    implements DoubleSequence {
        _ZInt() {
        }

        @Override
        public double f(int n) {
            if (n <= 1) {
                return Double.POSITIVE_INFINITY;
            }
            return RIEMANN_ZETA_MINUS1_SEQUENCE.f(n) + 1.0;
        }
    }

    static class _ZInt0
    implements DoubleSequence {
        double[] cache = new double[1000];

        _ZInt0() {
        }

        @Override
        public double f(int n) {
            if (n <= 1) {
                return Double.POSITIVE_INFINITY;
            }
            if (n >= 1000 || this.cache[n] == 0.0) {
                double r = ZetaFunctions.calculateZ(n);
                if (n < 1000) {
                    this.cache[n] = r + 1.0;
                }
                return r + 1.0;
            }
            return this.cache[n];
        }
    }

    static class _ZIntMinus1
    implements DoubleSequence {
        double[] cache = new double[1024];

        _ZIntMinus1() {
            String s = ZetaFunctions.class.getPackage().getName();
            BufferedReader rd = null;
            try {
                try {
                    String l;
                    s = "/" + s.replace('.', '/') + "/" + ZetaFunctions.ZETA_INTEGER;
                    rd = new BufferedReader(new InputStreamReader(ZetaFunctions.class.getResourceAsStream(s)));
                    int i = 2;
                    while ((l = rd.readLine()) != null) {
                        this.cache[i] = Double.parseDouble(l);
                        ++i;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (rd != null) {
                    try {
                        rd.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        @Override
        public double f(int n) {
            if (n <= 1) {
                return Double.POSITIVE_INFINITY;
            }
            if (n >= this.cache.length || this.cache[n] == 0.0) {
                double r = ZetaFunctions.calculateZ(n);
                if (n < this.cache.length) {
                    this.cache[n] = r;
                }
                return r;
            }
            return this.cache[n];
        }
    }
}

