/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.stat.dist;

import net.morilib.math.stat.dist.AbstractDiscreteDistribution;
import net.morilib.math.stat.dist.ContinuousDistribution;

public class ContinuousDistributionHistogram
extends AbstractDiscreteDistribution {
    private double max;
    private double min;
    private double dx;
    private ContinuousDistribution dist;

    @Override
    public double cdf(double x) {
        double n = Math.floor(x);
        if (n < 0.0) {
            return 0.0;
        }
        if (n * this.dx < this.max - this.min) {
            return this.dist.cdf(n * this.dx + this.min);
        }
        return 1.0;
    }

    @Override
    public double expectedValue() {
        return this.dist.expectedValue();
    }

    @Override
    public double variance() {
        return this.dist.variance();
    }

    @Override
    public double mode() {
        return this.dist.mode();
    }

    @Override
    public double median() {
        return this.dist.median();
    }

    @Override
    public double skewness() {
        return this.dist.skewness();
    }

    @Override
    public double kurtosis() {
        return this.dist.kurtosis();
    }

    @Override
    public double f(int n) {
        if (n < 0) {
            return 0.0;
        }
        if ((double)n * this.dx < this.max - this.min) {
            return this.dist.cdf((double)n * this.dx + this.min, (double)(n + 1) * this.dx + this.min);
        }
        return 1.0;
    }

    @Override
    public boolean isInSupport(int n) {
        return n >= 0 && this.dist.isInSupport((double)n * this.dx + this.min);
    }

    @Override
    public int supportMinimum() {
        return 0;
    }
}

