/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;

public final class NetUtils {
    private NetUtils() {
    }

    public static int readnum(InputStream rd) throws IOException {
        int c = rd.read();
        if (c < 48 || c > 57) {
            throw new ProtocolException();
        }
        return c - 48;
    }

    public static int readCode(InputStream rd, int ok, int okto) throws IOException {
        int r = NetUtils.readnum(rd) * 100;
        r += NetUtils.readnum(rd) * 10;
        if ((r += NetUtils.readnum(rd)) < ok || r > okto) {
            throw new ProtocolException(String.valueOf(r) + NetUtils.getReason(rd));
        }
        return r;
    }

    public static int readCode(InputStream rd, int ok) throws IOException {
        return NetUtils.readCode(rd, ok, ok + 99);
    }

    public static int getCode(InputStream rd, int ok, int okto) throws IOException {
        int r = NetUtils.readnum(rd) * 100;
        r += NetUtils.readnum(rd) * 10;
        if ((r += NetUtils.readnum(rd)) < ok || r > okto) {
            throw new ProtocolException(String.valueOf(r) + NetUtils.getReason(rd));
        }
        int c = rd.read();
        while (true) {
            if (c == 13) {
                c = rd.read();
                if (c < 0) {
                    throw new ProtocolException();
                }
                if (c == 10) {
                    return r;
                }
            }
            c = rd.read();
        }
    }

    public static int getCode(InputStream rd, int ok) throws IOException {
        return NetUtils.getCode(rd, ok, ok + 99);
    }

    public static int getCode(InputStream rd) throws IOException {
        int r = NetUtils.readnum(rd) * 100;
        r += NetUtils.readnum(rd) * 10;
        r += NetUtils.readnum(rd);
        int c = rd.read();
        while (true) {
            if (c == 13) {
                c = rd.read();
                if (c < 0) {
                    throw new ProtocolException();
                }
                if (c == 10) {
                    return r;
                }
            }
            c = rd.read();
        }
    }

    public static String getReason(InputStream rd) throws IOException {
        StringBuilder b = new StringBuilder();
        int c = rd.read();
        while (true) {
            if (c == 13) {
                c = rd.read();
                if (c < 0) {
                    throw new ProtocolException();
                }
                if (c == 10) {
                    return b.toString();
                }
            } else {
                b.append((char)c);
            }
            c = rd.read();
        }
    }
}

