/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.net.CRLFPrintStream;
import net.morilib.net.NetUtils;
import net.morilib.net.ftp.FTPMode;
import net.morilib.util.Bytes;
import net.morilib.util.IOs;
import net.morilib.util.Strings;

public final class FTP {
    private static final int TIMEOUT = 10000;
    private static final int START_PORT = 20000;
    private static final int END_PORT = 65535;
    private static final SimpleDateFormat FMT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final Pattern PTN1 = Pattern.compile(".*\\(([0-9]+),([0-9]+),([0-9]+),([0-9]+),([0-9]+),([0-9]+)\\).*");
    private static final Pattern PTN2 = Pattern.compile(".*\"(.*?)\".*");

    public static int user(CRLFPrintStream pr, InputStream rd, String username) throws IOException {
        pr.print("USER ");
        pr.println(username);
        return NetUtils.getCode(rd, 300);
    }

    public static int pass(CRLFPrintStream pr, InputStream rd, String password) throws IOException {
        pr.print("PASS ");
        pr.println(password);
        return NetUtils.getCode(rd, 200);
    }

    public static String syst(CRLFPrintStream pr, InputStream rd) throws IOException {
        pr.println("SYST");
        NetUtils.readCode(rd, 200);
        return NetUtils.getReason(rd).trim();
    }

    static int port(CRLFPrintStream pr, InputStream rd, Inet4Address addr, int port) throws IOException {
        if (addr == null) {
            throw new NullPointerException();
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        byte[] bts = addr.getAddress();
        pr.print("PORT ");
        pr.print(Integer.toString(Bytes.ubyteToInt(bts[0])));
        pr.print(",");
        pr.print(Integer.toString(Bytes.ubyteToInt(bts[1])));
        pr.print(",");
        pr.print(Integer.toString(Bytes.ubyteToInt(bts[2])));
        pr.print(",");
        pr.print(Integer.toString(Bytes.ubyteToInt(bts[3])));
        pr.print(",");
        pr.print(Integer.toString(port >> 8));
        pr.print(",");
        pr.println(Integer.toString(port & 0xFF));
        return NetUtils.getCode(rd, 200);
    }

    static int list(CRLFPrintStream pr, InputStream rd) throws IOException {
        pr.println("LIST");
        return NetUtils.getCode(rd, 100);
    }

    public static int type(CRLFPrintStream pr, InputStream rd, FTPMode mode) throws IOException {
        pr.print("TYPE ");
        pr.println(mode.getType());
        return NetUtils.getCode(rd, 200);
    }

    public static int typeAscii(CRLFPrintStream pr, InputStream rd) throws IOException {
        pr.println("TYPE A");
        return NetUtils.getCode(rd, 200);
    }

    public static int typeBinary(CRLFPrintStream pr, InputStream rd) throws IOException {
        pr.println("TYPE I");
        return NetUtils.getCode(rd, 200);
    }

    public static int quit(CRLFPrintStream pr, InputStream rd) throws IOException {
        pr.println("QUIT");
        return NetUtils.getCode(rd, 200);
    }

    public static int mkd(CRLFPrintStream pr, InputStream rd, String newdir) throws IOException {
        pr.print("MKD ");
        pr.println(newdir);
        return NetUtils.getCode(rd);
    }

    public static int rmd(CRLFPrintStream pr, InputStream rd, String deldir) throws IOException {
        pr.print("RMD ");
        pr.println(deldir);
        return NetUtils.getCode(rd);
    }

    public static int rnfr(CRLFPrintStream pr, InputStream rd, String renameFrom) throws IOException {
        pr.print("RNFR ");
        pr.println(renameFrom);
        return NetUtils.getCode(rd);
    }

    public static int rnto(CRLFPrintStream pr, InputStream rd, String renameTo) throws IOException {
        pr.print("RNTO ");
        pr.println(renameTo);
        return NetUtils.getCode(rd);
    }

    public static int dele(CRLFPrintStream pr, InputStream rd, String filename) throws IOException {
        pr.print("DELE ");
        pr.println(filename);
        return NetUtils.getCode(rd);
    }

    static ServerSocket getServerSocket(InetAddress addr) {
        int i = 20000;
        while (i <= 65535) {
            try {
                return new ServerSocket(i, 0, addr);
            }
            catch (IOException iOException) {
                ++i;
            }
        }
        return null;
    }

    public static long size(CRLFPrintStream pr, InputStream rd, String filename) throws IOException {
        int c;
        long l = 0L;
        pr.print("SIZE ");
        pr.println(filename);
        NetUtils.readCode(rd, 200);
        while ((c = rd.read()) >= 0 && Character.isWhitespace(c)) {
        }
        while (c >= 0 && c >= 48 && c <= 57) {
            l = l * 10L + (long)(c - 48);
            c = rd.read();
        }
        if (c != 13 || rd.read() != 10) {
            throw new ProtocolException("bad time");
        }
        return l;
    }

    public static Date mdtm(CRLFPrintStream pr, InputStream rd, String filename) throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        pr.print("MDTM ");
        pr.println(filename);
        NetUtils.readCode(rd, 200);
        while ((c = rd.read()) >= 0 && Character.isWhitespace(c)) {
        }
        while (c >= 0 && c >= 48 && c <= 57) {
            b.append((char)c);
            c = rd.read();
        }
        if (c != 13 || rd.read() != 10) {
            throw new ProtocolException("bad time");
        }
        try {
            return FMT.parse(b.toString());
        }
        catch (ParseException e) {
            throw new ProtocolException("parse");
        }
    }

    public static String pwd(CRLFPrintStream pr, InputStream rd) throws IOException {
        pr.println("PWD");
        NetUtils.readCode(rd, 200);
        Matcher s = PTN2.matcher(NetUtils.getReason(rd));
        return s.matches() ? s.group(1) : null;
    }

    public static int cwd(CRLFPrintStream pr, InputStream rd, String dir) throws IOException {
        pr.print("CWD ");
        pr.println(dir);
        return NetUtils.getCode(rd);
    }

    public static String receiveList(CRLFPrintStream pr, InputStream rd, Inet4Address addr) throws IOException {
        ServerSocket sso = null;
        Socket sok = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            sso = FTP.getServerSocket(addr);
            if (sso == null) {
                throw new IOException("no free ports");
            }
            sso.setSoTimeout(10000);
            FTP.port(pr, rd, addr, sso.getLocalPort());
            FTP.list(pr, rd);
            sok = sso.accept();
            bis = new BufferedInputStream(sok.getInputStream());
            IOs.copy(bis, b);
            NetUtils.getCode(rd, 200);
        }
        catch (Throwable throwable) {
            IOs.close(bis);
            if (sok != null) {
                sok.close();
            }
            if (sso != null) {
                sso.close();
            }
            throw throwable;
        }
        IOs.close(bis);
        if (sok != null) {
            sok.close();
        }
        if (sso != null) {
            sso.close();
        }
        return new String(b.toByteArray(), "UTF-8");
    }

    public static List<String> receiveNameList(CRLFPrintStream pr, InputStream rd, Inet4Address addr) throws IOException {
        ServerSocket sso = null;
        Socket sok = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            sso = FTP.getServerSocket(addr);
            if (sso == null) {
                throw new IOException("no free ports");
            }
            sso.setSoTimeout(10000);
            FTP.port(pr, rd, addr, sso.getLocalPort());
            pr.println("NLST");
            NetUtils.getCode(rd, 100);
            sok = sso.accept();
            bis = new BufferedInputStream(sok.getInputStream());
            IOs.copy(bis, b);
            NetUtils.getCode(rd, 200);
        }
        catch (Throwable throwable) {
            IOs.close(bis);
            if (sok != null) {
                sok.close();
            }
            if (sso != null) {
                sso.close();
            }
            throw throwable;
        }
        IOs.close(bis);
        if (sok != null) {
            sok.close();
        }
        if (sso != null) {
            sso.close();
        }
        return Strings.toList(new StringTokenizer(new String(b.toByteArray(), "UTF-8"), "\r\n"));
    }

    public static int get(CRLFPrintStream pr, InputStream rd, String filename, Inet4Address addr, OutputStream ous) throws IOException {
        ServerSocket sso = null;
        Socket sok = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = new BufferedOutputStream(ous);
        try {
            sso = FTP.getServerSocket(addr);
            if (sso == null) {
                throw new IOException("no free ports");
            }
            sso.setSoTimeout(10000);
            FTP.port(pr, rd, addr, sso.getLocalPort());
            pr.print("RETR ");
            pr.println(filename);
            NetUtils.getCode(rd, 100);
            sok = sso.accept();
            bis = new BufferedInputStream(sok.getInputStream());
            IOs.copy(bis, bos);
            bos.flush();
        }
        catch (Throwable throwable) {
            IOs.close(bis);
            if (sok != null) {
                sok.close();
            }
            if (sso != null) {
                sso.close();
            }
            throw throwable;
        }
        IOs.close(bis);
        if (sok != null) {
            sok.close();
        }
        if (sso != null) {
            sso.close();
        }
        return NetUtils.getCode(rd, 200);
    }

    public static int put(CRLFPrintStream pr, InputStream rd, String filename, Inet4Address addr, InputStream ins) throws IOException {
        ServerSocket sso = null;
        Socket sok = null;
        BufferedInputStream bis = new BufferedInputStream(ins);
        BufferedOutputStream bos = null;
        try {
            sso = FTP.getServerSocket(addr);
            if (sso == null) {
                throw new IOException("no free ports");
            }
            sso.setSoTimeout(10000);
            FTP.port(pr, rd, addr, sso.getLocalPort());
            pr.print("STOR ");
            pr.println(filename);
            NetUtils.getCode(rd, 100);
            sok = sso.accept();
            bos = new BufferedOutputStream(sok.getOutputStream());
            IOs.copy(bis, bos);
            bos.flush();
        }
        catch (Throwable throwable) {
            IOs.close(bos);
            if (sok != null) {
                sok.close();
            }
            if (sso != null) {
                sso.close();
            }
            throw throwable;
        }
        IOs.close(bos);
        if (sok != null) {
            sok.close();
        }
        if (sso != null) {
            sso.close();
        }
        return NetUtils.getCode(rd, 200);
    }

    static InetSocketAddress getAddr(InputStream rd) throws IOException {
        int ok = 200;
        byte[] bts = new byte[4];
        int r = NetUtils.readnum(rd) * 100;
        r += NetUtils.readnum(rd) * 10;
        if ((r += NetUtils.readnum(rd)) < ok || r > ok + 99) {
            throw new ProtocolException(String.valueOf(r) + NetUtils.getReason(rd));
        }
        Matcher mt = PTN1.matcher(NetUtils.getReason(rd));
        if (mt.matches()) {
            bts[0] = (byte)Integer.parseInt(mt.group(1));
            bts[1] = (byte)Integer.parseInt(mt.group(2));
            bts[2] = (byte)Integer.parseInt(mt.group(3));
            bts[3] = (byte)Integer.parseInt(mt.group(4));
            int prt = Integer.parseInt(mt.group(5)) << 8;
            return new InetSocketAddress(InetAddress.getByAddress(bts), prt |= Integer.parseInt(mt.group(6)));
        }
        throw new ProtocolException("unknown port");
    }

    public static String receiveListPassive(CRLFPrintStream pr, InputStream rd) throws IOException {
        Socket sok = new Socket();
        BufferedInputStream bis = null;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            pr.println("PASV");
            InetSocketAddress paddr = FTP.getAddr(rd);
            pr.println("LIST");
            sok.connect(paddr);
            NetUtils.getCode(rd, 100);
            bis = new BufferedInputStream(sok.getInputStream());
            IOs.copy(bis, b);
            NetUtils.getCode(rd, 200);
        }
        catch (Throwable throwable) {
            IOs.close(bis);
            if (sok != null) {
                sok.close();
            }
            throw throwable;
        }
        IOs.close(bis);
        if (sok != null) {
            sok.close();
        }
        return new String(b.toByteArray(), "UTF-8");
    }

    public static List<String> receiveNameListPassive(CRLFPrintStream pr, InputStream rd) throws IOException {
        Socket sok = new Socket();
        BufferedInputStream bis = null;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            pr.println("PASV");
            InetSocketAddress paddr = FTP.getAddr(rd);
            pr.println("NLST");
            sok.connect(paddr);
            NetUtils.getCode(rd, 100);
            bis = new BufferedInputStream(sok.getInputStream());
            IOs.copy(bis, b);
            NetUtils.getCode(rd, 200);
        }
        catch (Throwable throwable) {
            IOs.close(bis);
            if (sok != null) {
                sok.close();
            }
            throw throwable;
        }
        IOs.close(bis);
        if (sok != null) {
            sok.close();
        }
        return Strings.toList(new StringTokenizer(new String(b.toByteArray(), "UTF-8"), "\r\n"));
    }

    public static int getPassive(CRLFPrintStream pr, InputStream rd, String filename, OutputStream ous) throws IOException {
        ServerSocket sso = null;
        Socket sok = new Socket();
        BufferedInputStream bis = null;
        BufferedOutputStream bos = new BufferedOutputStream(ous);
        try {
            pr.println("PASV");
            InetSocketAddress paddr = FTP.getAddr(rd);
            pr.print("RETR ");
            pr.println(filename);
            sok.connect(paddr);
            NetUtils.getCode(rd, 100);
            bis = new BufferedInputStream(sok.getInputStream());
            IOs.copy(bis, bos);
            bos.flush();
        }
        catch (Throwable throwable) {
            IOs.close(bis);
            if (sok != null) {
                sok.close();
            }
            if (sso != null) {
                sso.close();
            }
            throw throwable;
        }
        IOs.close(bis);
        if (sok != null) {
            sok.close();
        }
        if (sso != null) {
            sso.close();
        }
        return NetUtils.getCode(rd, 200);
    }

    public static int putPassive(CRLFPrintStream pr, InputStream rd, String filename, InputStream ins) throws IOException {
        ServerSocket sso = null;
        Socket sok = new Socket();
        BufferedInputStream bis = new BufferedInputStream(ins);
        BufferedOutputStream bos = null;
        try {
            pr.println("PASV");
            InetSocketAddress paddr = FTP.getAddr(rd);
            pr.print("STOR ");
            pr.println(filename);
            sok.connect(paddr);
            NetUtils.getCode(rd, 100);
            bos = new BufferedOutputStream(sok.getOutputStream());
            IOs.copy(bis, bos);
            bos.flush();
        }
        catch (Throwable throwable) {
            IOs.close(bos);
            if (sok != null) {
                sok.close();
            }
            if (sso != null) {
                sso.close();
            }
            throw throwable;
        }
        IOs.close(bos);
        if (sok != null) {
            sok.close();
        }
        if (sso != null) {
            sso.close();
        }
        return NetUtils.getCode(rd, 200);
    }
}

