/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.List;
import net.morilib.net.CRLFPrintStream;
import net.morilib.net.NetUtils;
import net.morilib.net.ftp.FTP;
import net.morilib.net.ftp.FTPMode;
import net.morilib.util.IOs;

public abstract class FTPClient {
    InetAddress address = null;
    int port = 21;
    transient Socket socket = null;
    transient InputStream rd = null;
    transient CRLFPrintStream pr = null;
    transient FTPMode mode;

    public FTPClient() {
    }

    public FTPClient(InetAddress address, int port, String username, String password) throws IOException {
        this.address = address;
        this.port = port;
        this.connect(address, port, username, password);
    }

    public FTPClient(InetAddress address, String username, String password) throws IOException {
        this(address, 21, username, password);
    }

    public void connect(InetAddress address, int port, String username, String password) throws IOException {
        this.socket = new Socket(address, port);
        this.rd = this.socket.getInputStream();
        this.pr = new CRLFPrintStream(this.socket.getOutputStream());
        NetUtils.getCode(this.rd, 200);
        this.login(username, password);
        this.setMode(FTPMode.BINARY);
    }

    public void close() {
        IOs.close(this.rd);
        IOs.close(this.pr);
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void login(String username, String password) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        FTP.user(this.pr, this.rd, username);
        FTP.pass(this.pr, this.rd, password);
    }

    public void quit() throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        FTP.quit(this.pr, this.rd);
    }

    public String system() throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        return FTP.syst(this.pr, this.rd);
    }

    public boolean delete(String filename) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        int r = FTP.dele(this.pr, this.rd, filename);
        return r >= 200 && r < 300;
    }

    public String pwd() throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        return FTP.pwd(this.pr, this.rd);
    }

    public boolean cwd(String dir) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        int r = FTP.cwd(this.pr, this.rd, dir);
        return r >= 200 && r < 300;
    }

    public boolean mkdir(String dir) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        int r = FTP.mkd(this.pr, this.rd, dir);
        return r >= 200 && r < 300;
    }

    public boolean rmdir(String dir) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        int r = FTP.rmd(this.pr, this.rd, dir);
        return r >= 200 && r < 300;
    }

    public boolean rename(String from, String to) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        int r = FTP.rnfr(this.pr, this.rd, from);
        if (r >= 300 && r < 400) {
            r = FTP.rnto(this.pr, this.rd, to);
            return r >= 200 && r < 300;
        }
        return false;
    }

    public void setMode(FTPMode mode) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        FTP.type(this.pr, this.rd, mode);
        this.mode = mode;
    }

    public long getSize(String filename) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        return FTP.size(this.pr, this.rd, filename);
    }

    public Date getTimestamp(String filename) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException();
        }
        return FTP.mdtm(this.pr, this.rd, filename);
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public abstract String list() throws IOException;

    public abstract List<String> nameList() throws IOException;

    public abstract void put(String var1, InputStream var2) throws IOException;

    public abstract void get(String var1, OutputStream var2) throws IOException;

    public void put(String filename, File localfile) throws IOException {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(localfile);
            this.put(filename, ins);
        }
        catch (Throwable throwable) {
            IOs.close(ins);
            throw throwable;
        }
        IOs.close(ins);
    }

    public void get(String filename, File localfile) throws IOException {
        FileOutputStream ous = null;
        try {
            ous = new FileOutputStream(localfile);
            this.get(filename, ous);
        }
        catch (Throwable throwable) {
            IOs.close(ous);
            throw throwable;
        }
        IOs.close(ous);
    }

    public void put(String filename, String localfile) throws IOException {
        this.put(filename, new File(localfile));
    }

    public void get(String filename, String localfile) throws IOException {
        this.get(filename, new File(localfile));
    }

    public void put(File filename) throws IOException {
        this.put(filename.getName(), filename);
    }

    public void get(File filename) throws IOException {
        this.get(filename.getName(), filename);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public FTPMode getMode() {
        return this.mode;
    }
}

