/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.misc;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class UDPServiceInputStream
extends InputStream {
    private static final int BUFSIZE = 1024;
    private DatagramSocket sok;
    private DatagramPacket emptyPkt;
    private DatagramPacket pkt;
    private byte[] buf = new byte[1024];
    private int ptr;
    private int maxlength;

    public UDPServiceInputStream(InetAddress address, int port) throws IOException {
        this.sok = new DatagramSocket();
        this.pkt = new DatagramPacket(this.buf, this.buf.length);
        this.emptyPkt = new DatagramPacket(new byte[0], 0, address, port);
        this.reload();
    }

    public UDPServiceInputStream chargen(InetAddress address) throws IOException {
        return new UDPServiceInputStream(address, 19);
    }

    public UDPServiceInputStream netstat(InetAddress address) throws IOException {
        return new UDPServiceInputStream(address, 19);
    }

    public UDPServiceInputStream quoteOfDay(InetAddress address) throws IOException {
        return new UDPServiceInputStream(address, 17);
    }

    public UDPServiceInputStream statat(InetAddress address) throws IOException {
        return new UDPServiceInputStream(address, 11);
    }

    private void reload() throws IOException {
        this.sok.send(this.emptyPkt);
        this.sok.receive(this.pkt);
        this.ptr = 0;
        this.maxlength = this.pkt.getLength();
    }

    @Override
    public int read() throws IOException {
        byte r = this.buf[this.ptr++];
        if (this.ptr >= this.maxlength) {
            this.reload();
        }
        return r;
    }

    @Override
    public int available() throws IOException {
        return this.maxlength - this.ptr;
    }

    @Override
    public void close() throws IOException {
        this.sok.close();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = len;
        while (true) {
            if (l < this.available()) {
                System.arraycopy(this.buf, this.ptr, b, off, l);
                this.ptr += l;
                return len;
            }
            System.arraycopy(this.buf, this.ptr, b, off, this.available());
            l -= this.available();
            this.reload();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        long l = n;
        while (true) {
            if (l < (long)this.available()) {
                this.ptr = (int)((long)this.ptr + l);
                return n;
            }
            l -= (long)this.available();
            this.reload();
        }
    }
}

