/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.ntp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import net.morilib.net.ntp.NTPException;
import net.morilib.net.ntp.NTPInfo;
import net.morilib.net.ntp.NTPLeapIndicator;
import net.morilib.net.ntp.NTPMode;
import net.morilib.net.ntp.NTPReferenceInfo;
import net.morilib.net.ntp.NTPTimestamp;

public final class NTP {
    private static void readbts(DataInputStream din, byte[] b) throws IOException {
        if (din.read(b) != b.length) {
            throw new EOFException();
        }
    }

    private static NTPTimestamp gettm(long ntp) {
        return new NTPTimestamp(ntp >>> 32, ntp & 0xFFFFFFFFL);
    }

    private static long gettm(NTPTimestamp ntp) {
        if (ntp == null) {
            return 0L;
        }
        return ntp.getSeconds() << 32 | ntp.getFraction();
    }

    public static NTPInfo parsePacket(byte[] bts) throws NTPException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bts);
        DataInputStream din = new DataInputStream(bis);
        NTPInfo r = new NTPInfo();
        try {
            byte[] y;
            int b = din.readUnsignedByte();
            r.setLeapIndicator(NTPLeapIndicator.getFromNTPBits(b));
            r.setVersion((byte)(b >> 3 & 7));
            r.setMode(NTPMode.getFromNTPBits(b));
            int layer = din.readUnsignedByte();
            r.setPollingInterval(din.readByte());
            r.setPrecision(din.readByte());
            r.setRouteDelay(din.readInt());
            r.setRouteDispersion(din.readInt());
            if (layer == 0) {
                y = new byte[4];
                NTP.readbts(din, y);
                r.setReferenceInfo(new NTPReferenceInfo.Unknown(layer, new String(y)));
            } else if (layer == 1) {
                y = new byte[4];
                NTP.readbts(din, y);
                r.setReferenceInfo(new NTPReferenceInfo.Primary(new String(y)));
            } else if (layer >= 2 && layer <= 15) {
                y = new byte[4];
                NTP.readbts(din, y);
                r.setReferenceInfo(new NTPReferenceInfo.Secondary(layer, InetAddress.getByAddress(y)));
            } else {
                b = din.readInt();
                r.setReferenceInfo(new NTPReferenceInfo(layer));
            }
            r.setReferenceTime(NTP.gettm(din.readLong()));
            r.setOriginateTime(NTP.gettm(din.readLong()));
            r.setReceiveTime(NTP.gettm(din.readLong()));
            r.setTransmitTime(NTP.gettm(din.readLong()));
            r.setKeyIdentifier(din.readInt());
            y = new byte[16];
            NTP.readbts(din, y);
            r.setMessageDigest(y);
            return r;
        }
        catch (EOFException e) {
            throw new NTPException(e);
        }
        catch (IOException e) {
            throw new NTPException(e);
        }
    }

    public static byte[] toBytes(NTPInfo r) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream dot = new DataOutputStream(b);
        try {
            int c = r.getLeapIndicator().getCode() << 6;
            c |= r.getVersion() << 3;
            dot.writeByte(c |= r.getMode().getCode());
            dot.writeByte(0);
            dot.writeByte(r.getPollingInterval());
            dot.writeByte(r.getPrecision());
            dot.writeInt(r.getRouteDelay());
            dot.writeInt(r.getRouteDispersion());
            dot.writeInt(0);
            dot.writeLong(NTP.gettm(r.getReferenceTime()));
            dot.writeLong(NTP.gettm(r.getOriginateTime()));
            dot.writeLong(NTP.gettm(r.getReceiveTime()));
            dot.writeLong(NTP.gettm(r.getTransmitTime()));
            dot.writeInt(r.getKeyIdentifier());
            dot.write(new byte[16]);
            return b.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static NTPInfo receive(InetAddress addr, int port) throws IOException, NTPException {
        DatagramSocket sok = null;
        NTPInfo si = new NTPInfo();
        try {
            sok = new DatagramSocket();
            sok.setSoTimeout(5000);
            si.setVersion((byte)3);
            si.setMode(NTPMode.CLIANT);
            si.setTransmitTime(NTPTimestamp.localCurrentTime());
            byte[] y = NTP.toBytes(si);
            DatagramPacket pkt = new DatagramPacket(y, y.length, addr, port);
            byte[] z = new byte[1024];
            DatagramPacket lpk = new DatagramPacket(z, z.length);
            sok.send(pkt);
            sok.receive(lpk);
            NTPInfo ri = NTP.parsePacket(lpk.getData());
            ri.setOriginateLocalTime(si.getTransmitTime());
            NTPInfo nTPInfo = ri;
            return nTPInfo;
        }
        finally {
            if (sok != null) {
                sok.close();
            }
        }
    }

    public static NTPInfo receive(String host, int port) throws IOException, NTPException {
        return NTP.receive(InetAddress.getByName(host), port);
    }

    public static NTPInfo receive(InetAddress addr) throws IOException, NTPException {
        return NTP.receive(addr, 123);
    }

    public static NTPInfo receive(String host) throws IOException, NTPException {
        return NTP.receive(InetAddress.getByName(host), 123);
    }

    public static NTPTimestamp receiveTime(InetAddress addr, int port) throws IOException, NTPException {
        NTPInfo ri = NTP.receive(addr, port);
        long t = ri.getOriginateLocalTime().subtract(ri.getOriginateTime());
        NTPTimestamp r = NTPTimestamp.localCurrentTime();
        long s = ri.getReceiveTime().subtract(r);
        return r.add((t + s) / 2L);
    }

    public static NTPTimestamp receiveTime(String host, int port) throws IOException, NTPException {
        return NTP.receiveTime(InetAddress.getByName(host), port);
    }

    public static NTPTimestamp receiveTime(InetAddress addr) throws IOException, NTPException {
        return NTP.receiveTime(addr, 123);
    }

    public static NTPTimestamp receiveTime(String host) throws IOException, NTPException {
        return NTP.receiveTime(InetAddress.getByName(host), 123);
    }
}

