/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.ntp;

import java.net.InetAddress;

public class NTPReferenceInfo {
    private int layer;

    public NTPReferenceInfo(int layer) {
        this.layer = layer;
    }

    public boolean isValid() {
        return this.layer > 0;
    }

    public boolean isPrimary() {
        return this.layer == 1;
    }

    public boolean isSecondary() {
        return this.layer > 1 && this.layer <= 15;
    }

    public boolean isReserved() {
        return this.layer >= 16;
    }

    public int getLayer() {
        return this.layer > 0 && this.layer <= 15 ? this.layer : -1;
    }

    public String getSourceCode() {
        return null;
    }

    public InetAddress getSourceAddress() {
        return null;
    }

    public static class Primary
    extends NTPReferenceInfo {
        private String source;

        public Primary(String source) {
            super(1);
            this.source = source;
        }

        @Override
        public String getSourceCode() {
            return this.source;
        }
    }

    public static class Secondary
    extends NTPReferenceInfo {
        private InetAddress source;

        public Secondary(int layer, InetAddress source) {
            super(layer);
            this.source = source;
        }

        @Override
        public InetAddress getSourceAddress() {
            return this.source;
        }
    }

    public static class Unknown
    extends NTPReferenceInfo {
        private String source;

        public Unknown(int layer, String source) {
            super(layer);
            this.source = source;
        }

        @Override
        public String getSourceCode() {
            return this.source;
        }
    }
}

