/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.snmp;

import java.io.Serializable;

public class TimeTicks
implements Serializable {
    private long ticks;

    public TimeTicks(long ticks) {
        if (ticks < 0L) {
            throw new IllegalArgumentException();
        }
        this.ticks = ticks;
    }

    public TimeTicks add(TimeTicks ticks2) {
        return new TimeTicks(this.ticks + ticks2.ticks);
    }

    public TimeTicks sub(TimeTicks ticks2) {
        long t = this.ticks - ticks2.ticks;
        if (t < 0L) {
            throw new ArithmeticException();
        }
        return new TimeTicks(t);
    }

    public long toMilliseconds() {
        return this.ticks * 10L;
    }

    public double toSeconds() {
        return (double)this.ticks / 100.0;
    }

    public int hashCode() {
        return (int)this.ticks;
    }

    public boolean equals(Object o) {
        if (o instanceof TimeTicks) {
            return this.ticks == ((TimeTicks)o).ticks;
        }
        return false;
    }

    public String toString() {
        return String.format("%d.%02dsec", this.ticks / 100L, this.ticks % 100L);
    }
}

